/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.event;

import java.util.List;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.CSRFTokenUtil;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Event<T> {
    private String name_;
    private T source_;
    private Phase executionPhase_ = Phase.PROCESS;
    private WebuiRequestContext context_;
    private List<EventListener> listeners_;
    private boolean csrfCheck;
    private static final Log log = ExoLogger.getLogger((String)Event.class.getName());

    public Event(T source, String name, WebuiRequestContext context) {
        this.name_ = name;
        this.source_ = source;
        this.context_ = context;
    }

    public String getName() {
        return this.name_;
    }

    public T getSource() {
        return this.source_;
    }

    public Phase getExecutionPhase() {
        return this.executionPhase_;
    }

    public void setExecutionPhase(Phase phase) {
        this.executionPhase_ = phase;
    }

    public WebuiRequestContext getRequestContext() {
        return this.context_;
    }

    public void setRequestContext(WebuiRequestContext context) {
        this.context_ = context;
    }

    public List<EventListener> getEventListeners() {
        return this.listeners_;
    }

    public void setEventListeners(List<EventListener> listeners) {
        this.listeners_ = listeners;
    }

    public boolean isCsrfCheck() {
        return this.csrfCheck;
    }

    public void setCsrfCheck(boolean csrfCheck) {
        this.csrfCheck = csrfCheck;
    }

    public final void broadcast() throws Exception {
        if (this.isCsrfCheck() && !CSRFTokenUtil.check()) {
            this.getRequestContext().setResponseComplete(true);
            log.error((Object)"csrfToken is lost or this is an csrf attack");
        } else {
            for (EventListener listener : this.listeners_) {
                listener.execute(this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Phase {
        ANY,
        DECODE,
        PROCESS,
        RENDER;

    }
}

