/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.api.introspection;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.MethodInfo;
import org.reflext.api.MethodSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MethodContainer
implements Iterable<MethodInfo> {
    private final Map<MethodSignature, MethodInfo> map = new LinkedHashMap<MethodSignature, MethodInfo>();
    private final ClassTypeInfo context;

    MethodContainer(ClassTypeInfo context) {
        this.context = context;
    }

    MethodContainer() {
        this.context = null;
    }

    public void addAll(Iterable<MethodInfo> methods) {
        for (MethodInfo method : methods) {
            this.add(method);
        }
    }

    public boolean add(MethodInfo method) {
        MethodSignature key = this.context != null ? method.getSignature(this.context) : method.getSignature();
        MethodInfo existing = this.map.get(key);
        if (existing != null) {
            if (method.getReturnType().isSubType(existing.getReturnType()) && existing.getOwner().isAssignableFrom(method.getOwner())) {
                this.map.put(key, method);
                return true;
            }
        } else {
            this.map.put(key, method);
            return true;
        }
        return false;
    }

    public Set<MethodInfo> toCollection() {
        return new HashSet<MethodInfo>(this.map.values());
    }

    @Override
    public Iterator<MethodInfo> iterator() {
        return this.map.values().iterator();
    }
}

