/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.apt;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.chromattic.api.annotations.MixinType;
import org.chromattic.api.annotations.NamespaceMapping;
import org.chromattic.api.annotations.NodeTypeDefs;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.apt.PackageMetaData;
import org.chromattic.apt.PropertyLiteralGenerator;
import org.chromattic.apt.ProxyTypeGenerator;
import org.chromattic.common.collection.SetMap;
import org.chromattic.metamodel.mapping.BeanMapping;
import org.chromattic.metamodel.mapping.BeanMappingBuilder;
import org.chromattic.metamodel.typegen.CNDNodeTypeSerializer;
import org.chromattic.metamodel.typegen.NodeType;
import org.chromattic.metamodel.typegen.SchemaBuilder;
import org.chromattic.metamodel.typegen.XMLNodeTypeSerializer;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.TypeResolver;
import org.reflext.apt.JavaxLangReflectionModel;
import org.reflext.core.TypeResolverImpl;
import org.reflext.spi.model.ReflectionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedSourceVersion(value=SourceVersion.RELEASE_5)
@SupportedAnnotationTypes(value={"org.chromattic.api.annotations.PrimaryType", "org.chromattic.api.annotations.MixinType", "org.chromattic.api.annotations.Generate"})
public class ChromatticProcessor
extends AbstractProcessor {
    private final TypeResolver<Object> domain = TypeResolverImpl.create((ReflectionModel)JavaxLangReflectionModel.getInstance());
    private ProcessingEnvironment env;

    @Override
    public void init(ProcessingEnvironment env) {
        this.env = env;
        super.init(env);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            return this._process(annotations, roundEnv);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private boolean _process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        HashMap<String, PackageMetaData> packageMetaData = new HashMap<String, PackageMetaData>();
        Set<? extends Element> a = roundEnv.getElementsAnnotatedWith(NodeTypeDefs.class);
        for (Element element : a) {
            PackageElement pkgElt = (PackageElement)element;
            String packageName = "" + pkgElt.getQualifiedName();
            NodeTypeDefs ntDefs = pkgElt.getAnnotation(NodeTypeDefs.class);
            Map<String, String> prefixMappings = Collections.emptyMap();
            for (NamespaceMapping mapping : ntDefs.namespaces()) {
                if (prefixMappings.isEmpty()) {
                    prefixMappings = new HashMap<String, String>();
                }
                prefixMappings.put(mapping.prefix(), mapping.uri());
            }
            packageMetaData.put(packageName, new PackageMetaData(packageName, prefixMappings, ntDefs.deep()));
        }
        HashSet<Element> elts = new HashSet<Element>();
        elts.addAll(roundEnv.getElementsAnnotatedWith(PrimaryType.class));
        elts.addAll(roundEnv.getElementsAnnotatedWith(MixinType.class));
        try {
            this.process(roundEnv, elts, packageMetaData);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return true;
    }

    private void process(RoundEnvironment roundEnv, Set<Element> elts, Map<String, PackageMetaData> packageMetaDatas) throws Exception {
        Filer filer = this.processingEnv.getFiler();
        HashSet<ClassTypeInfo> classTypes = new HashSet<ClassTypeInfo>();
        SetMap packageToClassTypes = new SetMap();
        for (Element elt : elts) {
            TypeElement typeElt = (TypeElement)elt;
            ClassTypeInfo cti = (ClassTypeInfo)this.domain.resolve((Object)typeElt);
            TreeMap<Integer, PackageMetaData> packageSorter = new TreeMap<Integer, PackageMetaData>();
            for (PackageMetaData packageMetaData : packageMetaDatas.values()) {
                int dist = packageMetaData.distance(cti);
                if (dist < 0) continue;
                packageSorter.put(dist, packageMetaData);
            }
            if (packageSorter.size() > 0) {
                PackageMetaData packageMetaData = (PackageMetaData)packageSorter.values().iterator().next();
                Set set = packageToClassTypes.get((Object)packageMetaData.packageName);
                set.add(cti);
            }
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "About to process the type " + cti.getName());
            classTypes.add(cti);
            try {
                JavaFileObject jfo = filer.createSourceFile(typeElt.getQualifiedName() + "_Chromattic", typeElt);
                PrintWriter out = new PrintWriter(jfo.openWriter());
                StringBuilder builder = new StringBuilder();
                new ProxyTypeGenerator(cti).build(builder);
                out.write(builder.toString());
                out.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        BeanMappingBuilder amp = new BeanMappingBuilder();
        Map beanMappings = amp.build(classTypes);
        Map schema = new SchemaBuilder().build(beanMappings.values());
        for (BeanMapping beanMapping : beanMappings.values()) {
            if (beanMapping.isAbstract()) continue;
            new PropertyLiteralGenerator(beanMapping).build(filer);
        }
        for (String packageName : packageToClassTypes.keySet()) {
            this.env.getMessager().printMessage(Diagnostic.Kind.NOTE, "Processing node type package " + packageName);
            ArrayList<NodeType> nodeTypes = new ArrayList<NodeType>();
            Map<String, String> mappings = Collections.emptyMap();
            for (ClassTypeInfo cti : packageToClassTypes.get((Object)packageName)) {
                NodeType nodeType;
                PackageMetaData packageMetaData = packageMetaDatas.get(packageName);
                if (packageMetaData.prefixMappings.size() > 0) {
                    if (mappings.isEmpty()) {
                        mappings = new HashMap();
                    }
                    mappings.putAll(packageMetaData.prefixMappings);
                }
                if ((nodeType = (NodeType)schema.get(cti)) == null) continue;
                nodeTypes.add(nodeType);
            }
            FileObject cndFile = filer.createResource(StandardLocation.SOURCE_OUTPUT, packageName, "nodetypes.cnd", new Element[0]);
            CNDNodeTypeSerializer cndSerializer = new CNDNodeTypeSerializer(nodeTypes, mappings);
            Writer cndWriter = cndFile.openWriter();
            cndSerializer.writeTo(cndWriter);
            cndWriter.close();
            FileObject xmlFile = filer.createResource(StandardLocation.SOURCE_OUTPUT, packageName, "nodetypes.xml", new Element[0]);
            XMLNodeTypeSerializer xmlSerializer = new XMLNodeTypeSerializer(nodeTypes, mappings);
            Writer xmlWriter = xmlFile.openWriter();
            xmlSerializer.writeTo(xmlWriter);
            xmlWriter.close();
        }
    }
}

