/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl.ast;

import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.FunctionNode;
import de.odysseus.el.tree.impl.ast.AstInvocation;
import de.odysseus.el.tree.impl.ast.AstNode;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstFunction
extends AstInvocation
implements FunctionNode {
    private final int index;
    private final String name;

    public AstFunction(String name, int index, List<AstNode> nodes) {
        this(name, index, nodes, false);
    }

    public AstFunction(String name, int index, List<AstNode> nodes, boolean varargs) {
        super(nodes, varargs);
        this.name = name;
        this.index = index;
    }

    @Override
    public Object eval(Bindings bindings, ELContext context) {
        Method method = bindings.getFunction(this.index);
        try {
            return this.invoke(bindings, context, null, method);
        }
        catch (IllegalAccessException e) {
            throw new ELException(LocalMessages.get("error.function.access", this.name), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ELException(LocalMessages.get("error.function.invocation", this.name), e.getCause());
        }
    }

    public String toString() {
        return this.name + "(...)";
    }

    @Override
    public void appendStructure(StringBuilder b, Bindings bindings) {
        b.append(bindings != null && bindings.isFunctionBound(this.index) ? "<fn>" : this.name);
        b.append("(");
        if (this.getCardinality() > 0) {
            ((AstNode)this.nodes.get(0)).appendStructure(b, bindings);
            for (int i = 1; i < this.getCardinality(); ++i) {
                b.append(", ");
                ((AstNode)this.nodes.get(i)).appendStructure(b, bindings);
            }
        }
        b.append(")");
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getCardinality() {
        return this.getParamCount();
    }

    @Override
    public AstNode getChild(int i) {
        return this.getParam(i);
    }
}

