/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.ldap;

import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.exoplatform.services.ldap.LDAPService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.ldap.LDAPAttributeMapping;
import org.exoplatform.services.organization.ldap.LdapListAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByGroupLdapUserListAccess
extends LdapListAccess<User> {
    protected final String searchBase;
    protected final String filter;
    protected final LDAPAttributeMapping ldapAttrMapping;
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.organization.ldap.ByGroupLdapUserListAccess");
    private int size = -1;

    public ByGroupLdapUserListAccess(LDAPAttributeMapping ldapAttrMapping, LDAPService ldapService, String searchBase, String filter) {
        super(ldapService);
        this.ldapAttrMapping = ldapAttrMapping;
        this.searchBase = searchBase;
        this.filter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected User[] load(LdapContext ctx, int index, int length) throws Exception {
        User[] users = new User[length];
        NamingEnumeration<SearchResult> results = null;
        try {
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(1);
            results = ctx.search(this.searchBase, this.filter, constraints);
            int counter = 0;
            int p = 0;
            while (results.hasMoreElements() && counter < length) {
                Attribute attr;
                SearchResult result = results.next();
                Attributes attrs = result.getAttributes();
                if (attrs.size() == 0 || (attr = attrs.get(this.ldapAttrMapping.membershipTypeMemberValue)).size() == 0) continue;
                NamingEnumeration<?> members = attr.getAll();
                try {
                    while (members.hasMoreElements() && counter < length) {
                        Attributes uattr;
                        User user;
                        String member = (String)members.next();
                        if (p >= index && (user = this.ldapAttrMapping.attributesToUser(uattr = ctx.getAttributes(member))) != null) {
                            user.setFullName(user.getFirstName() + " " + user.getLastName());
                            users[counter++] = user;
                        }
                        ++p;
                    }
                }
                finally {
                    if (members == null) continue;
                    members.close();
                }
            }
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("range of users from " + index + " to " + (index + length)));
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getSize(LdapContext ctx) throws Exception {
        if (this.size < 0) {
            this.size = 0;
            NamingEnumeration<SearchResult> results = null;
            try {
                SearchControls constraints = new SearchControls();
                constraints.setSearchScope(1);
                results = ctx.search(this.searchBase, this.filter, constraints);
                while (results.hasMoreElements()) {
                    Attribute attr;
                    SearchResult result = results.next();
                    Attributes attrs = result.getAttributes();
                    if (attrs.size() == 0 || (attr = attrs.get(this.ldapAttrMapping.membershipTypeMemberValue)).size() == 0) continue;
                    NamingEnumeration<?> members = attr.getAll();
                    try {
                        while (members.hasMoreElements()) {
                            members.next();
                            ++this.size;
                        }
                    }
                    finally {
                        if (members == null) continue;
                        members.close();
                    }
                }
            }
            finally {
                if (results != null) {
                    results.close();
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("size : " + this.size));
        }
        return this.size;
    }
}

