/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.ldap;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.exoplatform.services.ldap.LDAPService;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.impl.MembershipImpl;
import org.exoplatform.services.organization.ldap.LDAPAttributeMapping;
import org.exoplatform.services.organization.ldap.LdapListAccess;
import org.exoplatform.services.organization.ldap.MembershipDAOImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MembershipsByGroupLdapListAccess
extends LdapListAccess<Membership> {
    protected final String groupId;
    protected final LDAPAttributeMapping ldapAttrMapping;
    protected final MembershipDAOImpl dao;

    public MembershipsByGroupLdapListAccess(LDAPService ldapService, MembershipDAOImpl dao, LDAPAttributeMapping ldapAttrMapping, String groupId) {
        super(ldapService);
        this.groupId = groupId;
        this.ldapAttrMapping = ldapAttrMapping;
        this.dao = dao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Membership[] load(LdapContext ctx, int index, int length) throws Exception {
        if (index < 0) {
            throw new IllegalArgumentException("Illegal index: index must be a positive number");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Illegal length: length must be a positive number");
        }
        Membership[] memberships = new Membership[length];
        int counter = 0;
        int p = 0;
        int err = 0;
        while (true) {
            String groupDN = this.dao.getGroupDNFromGroupId(this.groupId);
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(1);
            NamingEnumeration<SearchResult> results = ctx.search(groupDN, this.ldapAttrMapping.membershipObjectClassFilter, constraints);
            try {
                block7: while (true) {
                    if (!results.hasMoreElements()) {
                        if (counter < length) {
                            throw new IllegalArgumentException("Illegal index or length: sum of the index and the length cannot be greater than the list size");
                        }
                        break;
                    }
                    SearchResult sr = results.next();
                    String membershipType = this.dao.explodeDN(sr.getNameInNamespace(), true)[0];
                    Attributes attrs = sr.getAttributes();
                    Attribute attr = attrs.get(this.ldapAttrMapping.membershipTypeMemberValue);
                    int i = 0;
                    while (true) {
                        if (i >= attr.size()) continue block7;
                        if (p >= index) {
                            String userDN = String.valueOf(attr.get(i));
                            String userName = this.ldapAttrMapping.userDNKey.equals(this.ldapAttrMapping.userUsernameAttr) ? this.dao.explodeDN(userDN, true)[0] : this.dao.findUserByDN(ctx, userDN).getUserName();
                            MembershipImpl membership = this.dao.createMembershipObject(userName, this.groupId, membershipType);
                            memberships[counter++] = membership;
                            if (counter == length) {
                                Membership[] membershipArray = memberships;
                                return membershipArray;
                            }
                        }
                        ++p;
                        ++i;
                    }
                    break;
                }
            }
            catch (NamingException e) {
                ctx = this.dao.reloadCtx(ctx, err, e);
            }
            finally {
                results.close();
            }
            ++err;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getSize(LdapContext ctx) throws Exception {
        int size = 0;
        String groupDN = this.dao.getGroupDNFromGroupId(this.groupId);
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(1);
        NamingEnumeration<SearchResult> results = ctx.search(groupDN, this.ldapAttrMapping.membershipObjectClassFilter, constraints);
        try {
            while (results.hasMoreElements()) {
                Attributes attrs = results.next().getAttributes();
                Attribute attr = attrs.get(this.ldapAttrMapping.membershipTypeMemberValue);
                size += attr.size();
            }
        }
        finally {
            results.close();
        }
        return size;
    }
}

