/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.spi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.xcmis.spi.CmisRegistryFactory;
import org.xcmis.spi.CmisRuntimeException;
import org.xcmis.spi.utils.Logger;

class CmisRegistryFactoryFinder {
    private static final Logger LOG = Logger.getLogger(CmisRegistryFactoryFinder.class);

    CmisRegistryFactoryFinder() {
    }

    public static CmisRegistryFactory findCmisRegistry() {
        block12: {
            String name = null;
            try {
                name = System.getProperty("org.xcmis.CmisRegistryFactory");
                if (name != null) {
                    return CmisRegistryFactoryFinder.createInstance(null, name);
                }
            }
            catch (SecurityException se) {
                // empty catch block
            }
            String file = "META-INF/services/xcmis/org.xcmis.CmisRegistryFactory";
            InputStream in = null;
            ClassLoader classLoader = null;
            try {
                classLoader = Thread.currentThread().getContextClassLoader();
                in = classLoader.getResourceAsStream(file);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (in == null) {
                try {
                    classLoader = CmisRegistryFactoryFinder.class.getClassLoader();
                    in = classLoader.getResourceAsStream(file);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (in == null) {
                in = ClassLoader.getSystemResourceAsStream(file);
            }
            if (in != null) {
                try {
                    name = null;
                    BufferedReader rd = new BufferedReader(new InputStreamReader(in, Charset.forName("UTF-8")));
                    name = rd.readLine();
                    rd.close();
                    return CmisRegistryFactoryFinder.createInstance(classLoader, name);
                }
                catch (IOException e) {
                    if (!LOG.isDebugEnabled()) break block12;
                    LOG.error(e.getMessage(), e);
                }
            }
        }
        return null;
    }

    private static CmisRegistryFactory createInstance(ClassLoader classLoader, String name) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Try to create " + name);
        }
        try {
            Class<?> cls = null;
            cls = classLoader != null ? classLoader.loadClass(name) : Class.forName(name);
            return (CmisRegistryFactory)cls.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new CmisRuntimeException("Registry " + name + " not found. ", e);
        }
        catch (Exception e1) {
            throw new CmisRuntimeException("Can't instantiate factory " + name, e1);
        }
    }
}

