/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.resource.jcr;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.resource.JcrURLConnection;
import org.exoplatform.services.jcr.ext.resource.NodeRepresentationService;
import org.exoplatform.services.jcr.ext.resource.UnifiedNodeReference;
import org.exoplatform.services.security.ConversationState;
import org.picocontainer.Startable;

public class Handler
extends URLStreamHandler
implements Startable {
    private static final String protocolPathPkg = "org.exoplatform.services.jcr.ext.resource";
    private static RepositoryService repositoryService;
    private static NodeRepresentationService nodeRepresentationService;
    private static ThreadLocalSessionProviderService threadLocalSessionProviderService;

    public Handler(RepositoryService rs, NodeRepresentationService nrs, ThreadLocalSessionProviderService tsps) {
        repositoryService = rs;
        nodeRepresentationService = nrs;
        threadLocalSessionProviderService = tsps;
    }

    public Handler() {
    }

    protected URLConnection openConnection(URL url) throws IOException {
        try {
            String workspaceName;
            String repositoryName;
            UnifiedNodeReference nodeReference = new UnifiedNodeReference(url);
            SessionProvider sessionProvider = threadLocalSessionProviderService.getSessionProvider(null);
            boolean closeSessionProvider = false;
            if (sessionProvider == null && ConversationState.getCurrent() != null) {
                sessionProvider = (SessionProvider)ConversationState.getCurrent().getAttribute("JCRsessionProvider");
            }
            if (sessionProvider == null) {
                sessionProvider = SessionProvider.createAnonimProvider();
                closeSessionProvider = true;
            }
            if ((repositoryName = nodeReference.getRepository()) != null && repositoryName.length() > 0) {
                ManageableRepository repository = repositoryService.getRepository(repositoryName);
                sessionProvider.setCurrentRepository(repository);
            }
            if ((workspaceName = nodeReference.getWorkspace()) != null && workspaceName.length() > 0) {
                sessionProvider.setCurrentWorkspace(workspaceName);
            }
            JcrURLConnection conn = new JcrURLConnection(nodeReference, sessionProvider, nodeRepresentationService, closeSessionProvider);
            return conn;
        }
        catch (RepositoryException e) {
            throw new IOException("Open connection to URL '" + url.toString() + "' failed!");
        }
        catch (URISyntaxException e) {
            throw new IOException("Open connection to URL '" + url.toString() + "' failed!");
        }
        catch (RepositoryConfigurationException e) {
            throw new IOException("Open connection to URL '" + url.toString() + "' failed!");
        }
    }

    public void start() {
        String existingProtocolPathPkgs = PrivilegedSystemHelper.getProperty("java.protocol.handler.pkgs");
        if (existingProtocolPathPkgs == null) {
            PrivilegedSystemHelper.setProperty("java.protocol.handler.pkgs", protocolPathPkg);
        } else if (existingProtocolPathPkgs.indexOf(protocolPathPkg) == -1) {
            PrivilegedSystemHelper.setProperty("java.protocol.handler.pkgs", existingProtocolPathPkgs + "|" + protocolPathPkg);
        }
    }

    public void stop() {
    }
}

