/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.control.filter;

import java.security.AccessControlException;
import java.util.Map;
import javax.jcr.Node;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.ext.filter.UIExtensionAbstractFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilterType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsEditableFilter
extends UIExtensionAbstractFilter {
    public IsEditableFilter() {
        this("UIActionBar.msg.not-support");
    }

    public IsEditableFilter(String messageKey) {
        super(messageKey, UIExtensionFilterType.MANDATORY);
    }

    public boolean accept(Map<String, Object> context) throws Exception {
        if (context == null) {
            return true;
        }
        Node currentNode = (Node)context.get(Node.class.getName());
        String nodeType = currentNode.hasProperty("exo:presentationType") ? currentNode.getProperty("exo:presentationType").getString() : currentNode.getPrimaryNodeType().getName();
        for (String type : Utils.NON_EDITABLE_NODETYPES) {
            if (!type.equalsIgnoreCase(nodeType)) continue;
            return false;
        }
        String userName = Util.getPortalRequestContext().getRemoteUser();
        try {
            TemplateService templateService = (TemplateService)WCMCoreUtils.getService(TemplateService.class);
            templateService.getTemplatePathByUser(true, nodeType, userName);
        }
        catch (AccessControlException e) {
            return false;
        }
        return true;
    }

    public void onDeny(Map<String, Object> context) throws Exception {
        if (context == null) {
            return;
        }
        Node currentNode = (Node)context.get(Node.class.getName());
        Object[] arg = new Object[]{currentNode.getPath()};
        this.createUIPopupMessages(context, this.messageKey, arg);
    }
}

