/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinition;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.services.jcr.util.Text;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UICategoryForm
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_TYPE = "type";
    private static final Log LOG = ExoLogger.getLogger((String)UICategoryForm.class.getName());

    public void activate() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.setActions(new String[]{"Save", "Cancel"});
        this.getUIStringInput(FIELD_NAME).setValue(null);
    }

    public void deActivate() throws Exception {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UICategoryForm> {
        public void execute(Event<UICategoryForm> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UICategoryForm)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.cancelAction();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UICategoryForm> {
        public void execute(Event<UICategoryForm> event) throws Exception {
            UICategoryForm uiFolderForm = (UICategoryForm)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiFolderForm.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiFolderForm.getAncestorOfType(UIApplication.class);
            String title = (String)uiFolderForm.getUIStringInput(UICategoryForm.FIELD_NAME).getValue();
            String name = Utils.cleanString((String)title);
            Node node = uiExplorer.getCurrentNode();
            if (uiExplorer.nodeIsLocked(node)) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-locked", null));
                return;
            }
            if (name == null || name.length() == 0) {
                uiApp.addMessage(new ApplicationMessage("UIFolderForm.msg.name-invalid", null));
                return;
            }
            String type = "exo:taxonomy";
            try {
                Node newNode = node.addNode(Text.escapeIllegalJcrChars((String)name), type);
                if (newNode.canAddMixin("exo:rss-enable")) {
                    newNode.addMixin("exo:rss-enable");
                    newNode.setProperty("exo:title", title);
                }
                node.save();
                node.getSession().save();
                uiExplorer.updateAjax(event);
            }
            catch (ConstraintViolationException cve) {
                Object[] arg = new Object[]{type};
                throw new MessageException(new ApplicationMessage("UIFolderForm.msg.constraint-violation", arg, 1));
            }
            catch (AccessDeniedException accessDeniedException) {
                uiApp.addMessage(new ApplicationMessage("UIFolderForm.msg.repository-exception-permission", null, 1));
                return;
            }
            catch (RepositoryException re) {
                NodeDefinition[] definitions;
                String key = "";
                for (NodeDefinition def : definitions = node.getPrimaryNodeType().getChildNodeDefinitions()) {
                    key = node.hasNode(name) || !def.allowsSameNameSiblings() ? "UIFolderForm.msg.not-allow-sameNameSibling" : "UIFolderForm.msg.repository-exception";
                }
                uiApp.addMessage(new ApplicationMessage(key, null, 1));
                return;
            }
            catch (NumberFormatException nume) {
                String key = "UIFolderForm.msg.numberformat-exception";
                uiApp.addMessage(new ApplicationMessage(key, null, 1));
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Error when create category node", (Throwable)e);
                }
                return;
            }
        }
    }
}

