/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.admin;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.nodetype.ConstraintViolationException;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.mimetype.DMSMimeTypeResolver;
import org.exoplatform.services.jcr.impl.storage.JCRItemExistsException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.upload.UploadService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormUploadInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/explorer/popup/admin/UIFormWithMultiRadioBox.gtmpl", events={@EventConfig(listeners={ImportActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIImportNode
extends UIForm
implements UIPopupComponent {
    private static final Log LOG = ExoLogger.getLogger((String)UIImportNode.class.getName());
    public static final String FORMAT = "format";
    public static final String FILE_UPLOAD = "upload";
    public static final String IMPORT_BEHAVIOR = "behavior";
    public static final String VERSION_HISTORY_FILE_UPLOAD = "versionHistory";
    public static final String MAPPING_FILE = "mapping.properties";

    public UIImportNode() throws Exception {
        this.setMultiPart(true);
        UIFormUploadInput uiFileUpload = new UIFormUploadInput(FILE_UPLOAD, FILE_UPLOAD, 0);
        uiFileUpload.setAutoUpload(true);
        this.addUIFormInput((UIFormInput)uiFileUpload);
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(IMPORT_BEHAVIOR, IMPORT_BEHAVIOR, null));
        UIFormUploadInput uiHistoryFileUpload = new UIFormUploadInput(VERSION_HISTORY_FILE_UPLOAD, VERSION_HISTORY_FILE_UPLOAD, 0);
        uiHistoryFileUpload.setAutoUpload(true);
        this.addUIFormInput((UIFormInput)uiHistoryFileUpload);
    }

    public void activate() throws Exception {
        ArrayList<SelectItemOption> importBehavior = new ArrayList<SelectItemOption>();
        RequestContext context = RequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        importBehavior.add(new SelectItemOption(res.getString("Import.Behavior.type" + Integer.toString(0)), (Object)Integer.toString(0)));
        importBehavior.add(new SelectItemOption(res.getString("Import.Behavior.type" + Integer.toString(1)), (Object)Integer.toString(1)));
        importBehavior.add(new SelectItemOption(res.getString("Import.Behavior.type" + Integer.toString(2)), (Object)Integer.toString(2)));
        importBehavior.add(new SelectItemOption(res.getString("Import.Behavior.type" + Integer.toString(3)), (Object)Integer.toString(3)));
        this.getUIFormSelectBox(IMPORT_BEHAVIOR).setOptions(importBehavior);
    }

    public void deActivate() throws Exception {
    }

    private boolean validHistoryUploadFile(Event<?> event) throws Exception {
        UIFormUploadInput inputHistory = (UIFormUploadInput)this.getUIInput(VERSION_HISTORY_FILE_UPLOAD);
        UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
        ZipInputStream zipInputStream = new ZipInputStream(inputHistory.getUploadDataAsStream());
        ZipEntry entry = zipInputStream.getNextEntry();
        while (entry != null) {
            if (entry.getName().equals(MAPPING_FILE)) {
                zipInputStream.closeEntry();
                return true;
            }
            zipInputStream.closeEntry();
            entry = zipInputStream.getNextEntry();
        }
        zipInputStream.close();
        uiApp.addMessage(new ApplicationMessage("UIImportNode.msg.history-invalid-content", null, 1));
        return false;
    }

    private String getMimeType(String fileName) throws IOException {
        DMSMimeTypeResolver resolver = DMSMimeTypeResolver.getInstance();
        return resolver.getMimeType(fileName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIImportNode> {
        public void execute(Event<UIImportNode> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIImportNode)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.cancelAction();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImportActionListener
    extends EventListener<UIImportNode> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Event<UIImportNode> event) throws Exception {
            UIImportNode uiImport = (UIImportNode)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiImport.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiImport.getAncestorOfType(UIApplication.class);
            UIFormUploadInput input = (UIFormUploadInput)uiImport.getUIInput(UIImportNode.FILE_UPLOAD);
            UIFormUploadInput inputHistory = (UIFormUploadInput)uiImport.getUIInput(UIImportNode.VERSION_HISTORY_FILE_UPLOAD);
            Node currentNode = uiExplorer.getCurrentNode();
            Session session = currentNode.getSession();
            String nodePath = currentNode.getPath();
            uiExplorer.addLockToken(currentNode);
            if (input.getUploadResource() == null) {
                uiApp.addMessage(new ApplicationMessage("UIImportNode.msg.filename-invalid", null, 1));
                return;
            }
            if (inputHistory.getUploadResource() != null) {
                String mimeTypeHistory = uiImport.getMimeType(inputHistory.getUploadResource().getFileName());
                if (!mimeTypeHistory.equals("application/zip")) {
                    uiApp.addMessage(new ApplicationMessage("UIImportNode.msg.history-invalid-type", null, 1));
                    return;
                }
                if (!uiImport.validHistoryUploadFile(event)) {
                    return;
                }
            }
            String mimeType = uiImport.getMimeType(input.getUploadResource().getFileName());
            InputStream xmlInputStream = null;
            if ("text/xml".equals(mimeType)) {
                xmlInputStream = new BufferedInputStream(input.getUploadDataAsStream());
            } else if ("application/zip".equals(mimeType)) {
                ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(input.getUploadDataAsStream()));
                xmlInputStream = org.exoplatform.ecm.webui.utils.Utils.extractFirstEntryFromZipFile((ZipInputStream)zipInputStream);
            } else {
                uiApp.addMessage(new ApplicationMessage("UIImportNode.msg.mimetype-invalid", null, 1));
                return;
            }
            try {
                int importBehavior = Integer.parseInt((String)uiImport.getUIFormSelectBox(UIImportNode.IMPORT_BEHAVIOR).getValue());
                session.importXML(nodePath, xmlInputStream, importBehavior);
                try {
                    session.save();
                }
                catch (ConstraintViolationException e) {
                    session.refresh(false);
                    Object[] args = new Object[]{uiExplorer.getCurrentNode().getPrimaryNodeType().getName()};
                    uiApp.addMessage(new ApplicationMessage("UIImportNode.msg.constraint-violation-exception", args, 1));
                    UploadService uploadService = (UploadService)uiImport.getApplicationComponent(UploadService.class);
                    uploadService.removeUploadResource(input.getUploadId());
                    uploadService.removeUploadResource(inputHistory.getUploadId());
                    return;
                }
                if (inputHistory.getUploadResource() != null) {
                    Map mapHistoryValue = Utils.getMapImportHistory((InputStream)inputHistory.getUploadDataAsStream());
                    Utils.processImportHistory((Node)currentNode, (InputStream)inputHistory.getUploadDataAsStream(), (Map)mapHistoryValue);
                }
                uiApp.addMessage(new ApplicationMessage("UIImportNode.msg.import-successful", null));
            }
            catch (AccessDeniedException ace) {
                session.refresh(false);
                uiApp.addMessage(new ApplicationMessage("UIImportNode.msg.access-denied", null, 1));
                return;
            }
            catch (ConstraintViolationException con) {
                session.refresh(false);
                Object[] args = new Object[]{uiExplorer.getCurrentNode().getPrimaryNodeType().getName()};
                uiApp.addMessage(new ApplicationMessage("UIImportNode.msg.constraint-violation-exception", args, 1));
                return;
            }
            catch (JCRItemExistsException iee) {
                session.refresh(false);
                uiApp.addMessage(new ApplicationMessage("UIImportNode.msg.item-exists-exception", new Object[]{iee.getIdentifier()}, 1));
                return;
            }
            catch (Exception ise) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Unexpected error", (Throwable)ise);
                }
                session.refresh(false);
                uiApp.addMessage(new ApplicationMessage("UIImportNode.msg.filetype-error", null, 1));
                return;
            }
            finally {
                UploadService uploadService = (UploadService)uiImport.getApplicationComponent(UploadService.class);
                uploadService.removeUploadResource(input.getUploadId());
                uploadService.removeUploadResource(inputHistory.getUploadId());
            }
            uiExplorer.updateAjax(event);
        }
    }
}

