/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.xcmis.sp;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.ecms.xcmis.sp.StorageConfiguration;
import org.exoplatform.ecms.xcmis.sp.StorageImpl;
import org.exoplatform.ecms.xcmis.sp.TypeMapping;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.ContentStream;
import org.xcmis.spi.DocumentData;
import org.xcmis.spi.FolderData;
import org.xcmis.spi.ItemsIterator;
import org.xcmis.spi.NameConstraintViolationException;
import org.xcmis.spi.ObjectData;
import org.xcmis.spi.ObjectNotFoundException;
import org.xcmis.spi.PermissionService;
import org.xcmis.spi.PolicyData;
import org.xcmis.spi.RelationshipData;
import org.xcmis.spi.Storage;
import org.xcmis.spi.StorageException;
import org.xcmis.spi.TypeNotFoundException;
import org.xcmis.spi.UpdateConflictException;
import org.xcmis.spi.VersioningException;
import org.xcmis.spi.model.AccessControlEntry;
import org.xcmis.spi.model.AllowableActions;
import org.xcmis.spi.model.ChangeEvent;
import org.xcmis.spi.model.Property;
import org.xcmis.spi.model.Rendition;
import org.xcmis.spi.model.RepositoryInfo;
import org.xcmis.spi.model.TypeDefinition;
import org.xcmis.spi.model.UnfileObject;
import org.xcmis.spi.model.VersioningState;
import org.xcmis.spi.query.Query;
import org.xcmis.spi.query.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorageClosableImpl
implements Storage {
    private static final Log LOG = ExoLogger.getExoLogger((String)StorageClosableImpl.class.getName());
    private final PermissionService permissionService;
    private final StorageConfiguration rootStorageConfiguration;
    private final Map<String, TypeMapping> defaultNodetypeMapping;
    private final String workspaceName;
    private final ManageableRepository repository;
    private final SessionProvider sessionProvider;

    public StorageClosableImpl(SessionProvider sessionProvider, String workspaceName, ManageableRepository repository, StorageConfiguration rootStorageConfiguration, PermissionService permissionService, Map<String, TypeMapping> defaultNodetypeMapping) {
        this.sessionProvider = sessionProvider;
        this.workspaceName = workspaceName;
        this.repository = repository;
        this.rootStorageConfiguration = rootStorageConfiguration;
        this.permissionService = permissionService;
        this.defaultNodetypeMapping = defaultNodetypeMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AllowableActions calculateAllowableActions(ObjectData object) {
        Session session = null;
        try {
            session = this.sessionProvider.getSession(this.workspaceName, this.repository);
            StorageImpl storage = new StorageImpl(session, this.rootStorageConfiguration, null, this.permissionService, this.defaultNodetypeMapping);
            AllowableActions allowableActions = storage.calculateAllowableActions(object);
            return allowableActions;
        }
        catch (Exception e) {
            StorageClosableImpl.processException(e);
        }
        finally {
            session.logout();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentData copyDocument(DocumentData source, FolderData parent, Map<String, Property<?>> properties, List<AccessControlEntry> acl, Collection<PolicyData> policies, VersioningState versioningState) throws ConstraintException, NameConstraintViolationException, StorageException {
        Session session = null;
        try {
            session = this.sessionProvider.getSession(this.workspaceName, this.repository);
            StorageImpl storage = new StorageImpl(session, this.rootStorageConfiguration, null, this.permissionService, this.defaultNodetypeMapping);
            DocumentData documentData = storage.copyDocument(source, parent, properties, acl, policies, versioningState);
            return documentData;
        }
        catch (Exception e) {
            StorageClosableImpl.processException(e);
        }
        finally {
            session.logout();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentData createDocument(FolderData parent, TypeDefinition typeDefinition, Map<String, Property<?>> properties, ContentStream content, List<AccessControlEntry> acl, Collection<PolicyData> policies, VersioningState versioningState) throws ConstraintException, NameConstraintViolationException, IOException, StorageException {
        Session session = null;
        try {
            session = this.sessionProvider.getSession(this.workspaceName, this.repository);
            StorageImpl storage = new StorageImpl(session, this.rootStorageConfiguration, null, this.permissionService, this.defaultNodetypeMapping);
            DocumentData documentData = storage.createDocument(parent, typeDefinition, properties, content, acl, policies, versioningState);
            return documentData;
        }
        catch (Exception e) {
            StorageClosableImpl.processException(e);
        }
        finally {
            session.logout();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FolderData createFolder(FolderData parent, TypeDefinition typeDefinition, Map<String, Property<?>> properties, List<AccessControlEntry> acl, Collection<PolicyData> policies) throws ConstraintException, NameConstraintViolationException, StorageException {
        Session session = null;
        try {
            session = this.sessionProvider.getSession(this.workspaceName, this.repository);
            StorageImpl storage = new StorageImpl(session, this.rootStorageConfiguration, null, this.permissionService, this.defaultNodetypeMapping);
            FolderData folderData = storage.createFolder(parent, typeDefinition, properties, acl, policies);
            return folderData;
        }
        catch (Exception e) {
            StorageClosableImpl.processException(e);
        }
        finally {
            session.logout();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolicyData createPolicy(FolderData parent, TypeDefinition typeDefinition, Map<String, Property<?>> properties, List<AccessControlEntry> acl, Collection<PolicyData> policies) throws ConstraintException, NameConstraintViolationException, StorageException {
        Session session = null;
        try {
            session = this.sessionProvider.getSession(this.workspaceName, this.repository);
            StorageImpl storage = new StorageImpl(session, this.rootStorageConfiguration, null, this.permissionService, this.defaultNodetypeMapping);
            PolicyData policyData = storage.createPolicy(parent, typeDefinition, properties, acl, policies);
            return policyData;
        }
        catch (Exception e) {
            StorageClosableImpl.processException(e);
        }
        finally {
            session.logout();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationshipData createRelationship(ObjectData source, ObjectData target, TypeDefinition typeDefinition, Map<String, Property<?>> properties, List<AccessControlEntry> acl, Collection<PolicyData> policies) throws NameConstraintViolationException, StorageException {
        Session session = null;
        try {
            session = this.sessionProvider.getSession(this.workspaceName, this.repository);
            StorageImpl storage = new StorageImpl(session, this.rootStorageConfiguration, null, this.permissionService, this.defaultNodetypeMapping);
            RelationshipData relationshipData = storage.createRelationship(source, target, typeDefinition, properties, acl, policies);
            return relationshipData;
        }
        catch (Exception e) {
            StorageClosableImpl.processException(e);
        }
        finally {
            session.logout();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObject(ObjectData object, boolean deleteAllVersions) throws VersioningException, UpdateConflictException, StorageException {
        Session session = null;
        try {
            session = this.sessionProvider.getSession(this.workspaceName, this.repository);
            StorageImpl storage = new StorageImpl(session, this.rootStorageConfiguration, null, this.permissionService, this.defaultNodetypeMapping);
            storage.deleteObject(object, deleteAllVersions);
        }
        catch (Exception e) {
            StorageClosableImpl.processException(e);
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> deleteTree(FolderData folder, boolean deleteAllVersions, UnfileObject unfileObject, boolean continueOnFailure) throws UpdateConflictException {
        Session session = null;
        try {
            session = this.sessionProvider.getSession(this.workspaceName, this.repository);
            StorageImpl storage = new StorageImpl(session, this.rootStorageConfiguration, null, this.permissionService, this.defaultNodetypeMapping);
            Collection<String> collection = storage.deleteTree(folder, deleteAllVersions, unfileObject, continueOnFailure);
            return collection;
        }
        catch (Exception e) {
            StorageClosableImpl.processException(e);
        }
        finally {
            session.logout();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DocumentData> getAllVersions(String versionSeriesId) throws ObjectNotFoundException {
        Session session = null;
        try {
            session = this.sessionProvider.getSession(this.workspaceName, this.repository);
            StorageImpl storage = new StorageImpl(session, this.rootStorageConfiguration, null, this.permissionService, this.defaultNodetypeMapping);
            Collection<DocumentData> collection = storage.getAllVersions(versionSeriesId);
            return collection;
        }
        catch (Exception e) {
            StorageClosableImpl.processException(e);
        }
        finally {
            session.logout();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemsIterator<ChangeEvent> getChangeLog(String changeLogToken) throws ConstraintException {
        Session session = null;
        try {
            session = this.sessionProvider.getSession(this.workspaceName, this.repository);
            StorageImpl storage = new StorageImpl(session, this.rootStorageConfiguration, null, this.permissionService, this.defaultNodetypeMapping);
            ItemsIterator<ChangeEvent> itemsIterator = storage.getChangeLog(changeLogToken);
            return itemsIterator;
        }
        catch (Exception e) {
            StorageClosableImpl.processException(e);
        }
        finally {
            session.logout();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemsIterator<DocumentData> getCheckedOutDocuments(FolderData folder, String orderBy) {
        Session session = null;
        try {
            session = this.sessionProvider.getSession(this.workspaceName, this.repository);
            StorageImpl storage = new StorageImpl(session, this.rootStorageConfiguration, null, this.permissionService, this.defaultNodetypeMapping);
            ItemsIterator<DocumentData> itemsIterator = storage.getCheckedOutDocuments(folder, orderBy);
            return itemsIterator;
        }
        catch (Exception e) {
            StorageClosableImpl.processException(e);
        }
        finally {
            session.logout();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getId() {
        Session session = null;
        try {
            session = this.sessionProvider.getSession(this.workspaceName, this.repository);
            StorageImpl storage = new StorageImpl(session, this.rootStorageConfiguration, null, this.permissionService, this.defaultNodetypeMapping);
            String string = storage.getId();
            return string;
        }
        catch (Exception e) {
            StorageClosableImpl.processException(e);
        }
        finally {
            session.logout();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectData getObjectById(String objectId) throws ObjectNotFoundException {
        Session session = null;
        try {
            session = this.sessionProvider.getSession(this.workspaceName, this.repository);
            StorageImpl storage = new StorageImpl(session, this.rootStorageConfiguration, null, this.permissionService, this.defaultNodetypeMapping);
            ObjectData objectData = storage.getObjectById(objectId);
            return objectData;
        }
        catch (Exception e) {
            StorageClosableImpl.processException(e);
        }
        finally {
            session.logout();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectData getObjectByPath(String path) throws ObjectNotFoundException {
        Session session = null;
        try {
            session = this.sessionProvider.getSession(this.workspaceName, this.repository);
            StorageImpl storage = new StorageImpl(session, this.rootStorageConfiguration, null, this.permissionService, this.defaultNodetypeMapping);
            ObjectData objectData = storage.getObjectByPath(path);
            return objectData;
        }
        catch (Exception e) {
            StorageClosableImpl.processException(e);
        }
        finally {
            session.logout();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemsIterator<Rendition> getRenditions(ObjectData object) {
        Session session = null;
        try {
            session = this.sessionProvider.getSession(this.workspaceName, this.repository);
            StorageImpl storage = new StorageImpl(session, this.rootStorageConfiguration, null, this.permissionService, this.defaultNodetypeMapping);
            ItemsIterator<Rendition> itemsIterator = storage.getRenditions(object);
            return itemsIterator;
        }
        catch (Exception e) {
            StorageClosableImpl.processException(e);
        }
        finally {
            session.logout();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryInfo getRepositoryInfo() {
        Session session = null;
        try {
            session = this.sessionProvider.getSession(this.workspaceName, this.repository);
            StorageImpl storage = new StorageImpl(session, this.rootStorageConfiguration, null, this.permissionService, this.defaultNodetypeMapping);
            RepositoryInfo repositoryInfo = storage.getRepositoryInfo();
            return repositoryInfo;
        }
        catch (Exception e) {
            StorageClosableImpl.processException(e);
        }
        finally {
            session.logout();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<String> getUnfiledObjectsId() throws StorageException {
        Session session = null;
        try {
            session = this.sessionProvider.getSession(this.workspaceName, this.repository);
            StorageImpl storage = new StorageImpl(session, this.rootStorageConfiguration, null, this.permissionService, this.defaultNodetypeMapping);
            Iterator<String> iterator = storage.getUnfiledObjectsId();
            return iterator;
        }
        catch (Exception e) {
            StorageClosableImpl.processException(e);
        }
        finally {
            session.logout();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectData moveObject(ObjectData object, FolderData target, FolderData source) throws UpdateConflictException, VersioningException, NameConstraintViolationException, StorageException {
        Session session = null;
        try {
            session = this.sessionProvider.getSession(this.workspaceName, this.repository);
            StorageImpl storage = new StorageImpl(session, this.rootStorageConfiguration, null, this.permissionService, this.defaultNodetypeMapping);
            ObjectData objectData = storage.moveObject(object, target, source);
            return objectData;
        }
        catch (Exception e) {
            StorageClosableImpl.processException(e);
        }
        finally {
            session.logout();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemsIterator<Result> query(Query query) {
        Session session = null;
        try {
            session = this.sessionProvider.getSession(this.workspaceName, this.repository);
            StorageImpl storage = new StorageImpl(session, this.rootStorageConfiguration, null, this.permissionService, this.defaultNodetypeMapping);
            ItemsIterator<Result> itemsIterator = storage.query(query);
            return itemsIterator;
        }
        catch (Exception e) {
            StorageClosableImpl.processException(e);
        }
        finally {
            session.logout();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unfileObject(ObjectData object) {
        Session session = null;
        try {
            session = this.sessionProvider.getSession(this.workspaceName, this.repository);
            StorageImpl storage = new StorageImpl(session, this.rootStorageConfiguration, null, this.permissionService, this.defaultNodetypeMapping);
            storage.unfileObject(object);
        }
        catch (Exception e) {
            StorageClosableImpl.processException(e);
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addType(TypeDefinition type) throws ConstraintException, StorageException {
        Session session = null;
        try {
            session = this.sessionProvider.getSession(this.workspaceName, this.repository);
            StorageImpl storage = new StorageImpl(session, this.rootStorageConfiguration, null, this.permissionService, this.defaultNodetypeMapping);
            String string = storage.addType(type);
            return string;
        }
        catch (Exception e) {
            StorageClosableImpl.processException(e);
        }
        finally {
            session.logout();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemsIterator<TypeDefinition> getTypeChildren(String typeId, boolean includePropertyDefinitions) throws TypeNotFoundException {
        Session session = null;
        try {
            session = this.sessionProvider.getSession(this.workspaceName, this.repository);
            StorageImpl storage = new StorageImpl(session, this.rootStorageConfiguration, null, this.permissionService, this.defaultNodetypeMapping);
            ItemsIterator itemsIterator = storage.getTypeChildren(typeId, includePropertyDefinitions);
            return itemsIterator;
        }
        catch (Exception e) {
            StorageClosableImpl.processException(e);
        }
        finally {
            session.logout();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeDefinition getTypeDefinition(String typeId, boolean includePropertyDefinition) throws TypeNotFoundException {
        Session session = null;
        try {
            session = this.sessionProvider.getSession(this.workspaceName, this.repository);
            StorageImpl storage = new StorageImpl(session, this.rootStorageConfiguration, null, this.permissionService, this.defaultNodetypeMapping);
            TypeDefinition typeDefinition = storage.getTypeDefinition(typeId, includePropertyDefinition);
            return typeDefinition;
        }
        catch (Exception e) {
            StorageClosableImpl.processException(e);
        }
        finally {
            session.logout();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeType(String typeId) throws ConstraintException, TypeNotFoundException, StorageException {
        Session session = null;
        try {
            session = this.sessionProvider.getSession(this.workspaceName, this.repository);
            StorageImpl storage = new StorageImpl(session, this.rootStorageConfiguration, null, this.permissionService, this.defaultNodetypeMapping);
            storage.removeType(typeId);
        }
        catch (Exception e) {
            StorageClosableImpl.processException(e);
        }
        finally {
            session.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSupportedNodeType(String nodeTypeName) {
        Session session = null;
        try {
            session = this.sessionProvider.getSession(this.workspaceName, this.repository);
            StorageImpl storage = new StorageImpl(session, this.rootStorageConfiguration, null, this.permissionService, this.defaultNodetypeMapping);
            boolean bl = storage.isSupportedNodeType(nodeTypeName);
            return bl;
        }
        catch (Exception e) {
            StorageClosableImpl.processException(e);
        }
        finally {
            session.logout();
        }
        return false;
    }

    private static void processException(Exception e) {
        if (e instanceof LoginException) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        } else if (e instanceof NoSuchWorkspaceException) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        } else if (e instanceof RepositoryException && LOG.isErrorEnabled()) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

