/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.xcmis.sp;

import java.util.Collection;
import java.util.HashSet;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.ecms.xcmis.sp.BaseJcrStorage;
import org.exoplatform.ecms.xcmis.sp.JcrNodeEntry;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.xcmis.spi.CmisRuntimeException;
import org.xcmis.spi.ObjectNotFoundException;
import org.xcmis.spi.StorageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SymLinkNodeEntry
extends JcrNodeEntry {
    private Node link;

    public SymLinkNodeEntry(Node link, Node node, BaseJcrStorage storage) throws RepositoryException {
        super(node, storage);
        this.link = link;
    }

    @Override
    String getId() {
        try {
            return ((ExtendedNode)this.link).getIdentifier();
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get objects's id ." + re.getMessage(), (Throwable)re);
        }
    }

    @Override
    void delete() throws StorageException {
        try {
            Session session = this.link.getSession();
            this.link.remove();
            session.save();
        }
        catch (RepositoryException re) {
            throw new StorageException("Unable delete object. " + re.getMessage(), (Throwable)re);
        }
    }

    @Override
    Collection<JcrNodeEntry> getParents() {
        try {
            HashSet<JcrNodeEntry> parents = new HashSet<JcrNodeEntry>();
            Node parent = this.link.getParent();
            try {
                parents.add(this.storage.fromNode(parent));
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
            return parents;
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get object parent. " + re.getMessage(), (Throwable)re);
        }
    }

    @Override
    String path() {
        try {
            return this.link.getPath();
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable get JCR node path. " + re.getMessage(), (Throwable)re);
        }
    }

    @Override
    String getName() {
        try {
            return this.link.getName();
        }
        catch (RepositoryException re) {
            throw new CmisRuntimeException("Unable object's name. " + re.getMessage(), (Throwable)re);
        }
    }
}

