/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.typegen;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.chromattic.metamodel.mapping.BeanMapping;
import org.chromattic.metamodel.mapping.NodeTypeKind;
import org.chromattic.metamodel.typegen.NodeDefinition;
import org.chromattic.metamodel.typegen.PropertyDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeType {
    final BeanMapping mapping;
    final String name;
    final String className;
    final boolean mixin;
    final Map<String, NodeDefinition> children;
    final Map<String, PropertyDefinition> properties;
    final Set<NodeType> superTypes;
    final Set<NodeType> declaredSuperTypes;
    final boolean orderable;
    final boolean referenceable;

    NodeType(BeanMapping mapping, boolean referenceable) {
        this.mapping = mapping;
        this.name = mapping.getNodeTypeName();
        this.className = mapping.getBean().getClassType().getName();
        this.mixin = mapping.getNodeTypeKind() == NodeTypeKind.MIXIN;
        this.orderable = mapping.isOrderable();
        this.children = new HashMap<String, NodeDefinition>();
        this.properties = new HashMap<String, PropertyDefinition>();
        this.superTypes = new HashSet<NodeType>();
        this.declaredSuperTypes = new HashSet<NodeType>();
        this.referenceable = referenceable;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isDeclared() {
        return this.mapping.getBean().isDeclared();
    }

    public boolean isOrderable() {
        return this.orderable;
    }

    public boolean isReferenceable() {
        return this.referenceable;
    }

    public Collection<NodeType> getSuperTypes() {
        return this.superTypes;
    }

    public Set<NodeType> getDeclaredSuperTypes() {
        return this.declaredSuperTypes;
    }

    public PropertyDefinition getPropertyDefinition(String propertyName) {
        return this.properties.get(propertyName);
    }

    public Map<String, PropertyDefinition> getPropertyDefinitions() {
        return this.properties;
    }

    public String getName() {
        return this.name;
    }

    public boolean isMixin() {
        return this.mixin;
    }

    public boolean isPrimary() {
        return !this.mixin;
    }

    public Map<String, NodeDefinition> getChildNodeDefinitions() {
        return this.children;
    }

    public NodeDefinition getChildNodeDefinition(String childNodeName) {
        return this.children.get(childNodeName);
    }

    void addChildNodeType(String childNodeName, boolean mandatory, boolean autocreated, BeanMapping childNodeTypeMapping) {
        NodeDefinition nodeDefinition = this.children.get(childNodeName);
        if (nodeDefinition == null) {
            nodeDefinition = new NodeDefinition(childNodeName, mandatory, autocreated);
            this.children.put(childNodeName, nodeDefinition);
        }
        nodeDefinition.mappings.add(childNodeTypeMapping);
    }

    public String toString() {
        return "NodeType[name=" + this.name + "]";
    }
}

