/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.fonts.ofont;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.fonts.CMap;
import org.icepdf.core.pobjects.fonts.FontFile;
import org.icepdf.core.pobjects.fonts.ofont.Encoding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OFont
implements FontFile {
    private static final Logger log = Logger.getLogger(OFont.class.toString());
    private Font awtFont;
    private Rectangle2D maxCharBounds = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
    private HashMap<String, Point2D.Float> echarAdvanceCache;
    protected float[] widths;
    protected Map<Integer, Float> cidWidths;
    protected float missingWidth;
    protected int firstCh;
    protected float ascent;
    protected float descent;
    protected org.icepdf.core.pobjects.fonts.Encoding encoding;
    protected CMap toUnicode;
    protected char[] cMap;

    public OFont(Font awtFont) {
        this.awtFont = awtFont;
        this.maxCharBounds = new Rectangle2D.Double();
        this.echarAdvanceCache = new HashMap(256);
    }

    private OFont(OFont font) {
        this.echarAdvanceCache = font.echarAdvanceCache;
        this.awtFont = font.awtFont;
        this.encoding = font.encoding;
        this.toUnicode = font.toUnicode;
        this.missingWidth = font.missingWidth;
        this.firstCh = font.firstCh;
        this.ascent = font.ascent;
        this.descent = font.descent;
        this.widths = font.widths;
        this.cidWidths = font.cidWidths;
        this.cMap = font.cMap;
        this.maxCharBounds = font.maxCharBounds;
    }

    @Override
    public FontFile deriveFont(org.icepdf.core.pobjects.fonts.Encoding encoding, CMap toUnicode) {
        OFont font = new OFont(this);
        this.echarAdvanceCache.clear();
        font.encoding = encoding;
        font.toUnicode = toUnicode;
        return font;
    }

    @Override
    public FontFile deriveFont(float[] widths, int firstCh, float missingWidth, float ascent, float descent, char[] diff) {
        OFont font = new OFont(this);
        this.echarAdvanceCache.clear();
        font.missingWidth = this.missingWidth;
        font.firstCh = firstCh;
        font.ascent = ascent;
        font.descent = descent;
        font.widths = widths;
        font.cMap = diff;
        return font;
    }

    @Override
    public FontFile deriveFont(Map<Integer, Float> widths, int firstCh, float missingWidth, float ascent, float descent, char[] diff) {
        OFont font = new OFont(this);
        this.echarAdvanceCache.clear();
        font.missingWidth = this.missingWidth;
        font.firstCh = firstCh;
        font.ascent = ascent;
        font.descent = descent;
        font.cidWidths = widths;
        font.cMap = diff;
        return font;
    }

    @Override
    public FontFile deriveFont(AffineTransform at) {
        OFont font = new OFont(this);
        if (!font.getTransform().equals(this.awtFont.getTransform())) {
            this.echarAdvanceCache.clear();
        }
        font.awtFont = this.awtFont.deriveFont(at);
        font.maxCharBounds = this.maxCharBounds;
        return font;
    }

    @Override
    public boolean canDisplayEchar(char ech) {
        return true;
    }

    @Override
    public FontFile deriveFont(float pointsize) {
        OFont font = new OFont(this);
        if (font.getSize() != pointsize) {
            this.echarAdvanceCache.clear();
        }
        font.awtFont = this.awtFont.deriveFont(pointsize);
        font.maxCharBounds = this.maxCharBounds;
        return font;
    }

    @Override
    public Point2D echarAdvance(char ech) {
        float advanceY;
        float advance;
        String text = String.valueOf(ech);
        Point2D.Float echarAdvance = this.echarAdvanceCache.get(text);
        if (echarAdvance == null) {
            char echGlyph = this.getCMapping(ech);
            GlyphVector glyphVector = this.awtFont.createGlyphVector(new FontRenderContext(new AffineTransform(), true, true), String.valueOf(echGlyph));
            FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
            TextLayout textLayout = new TextLayout(String.valueOf(echGlyph), this.awtFont, frc);
            this.maxCharBounds = this.awtFont.getMaxCharBounds(frc);
            this.ascent = textLayout.getAscent();
            this.descent = textLayout.getDescent();
            GlyphMetrics glyphMetrics = glyphVector.getGlyphMetrics(0);
            advance = glyphMetrics.getAdvanceX();
            advanceY = glyphMetrics.getAdvanceY();
            this.echarAdvanceCache.put(text, new Point2D.Float(advance, advanceY));
        } else {
            advance = echarAdvance.x;
            advanceY = echarAdvance.y;
        }
        if (this.widths != null && ech - this.firstCh >= 0 && ech - this.firstCh < this.widths.length) {
            advance = this.widths[ech - this.firstCh] * this.awtFont.getSize2D();
        } else if (this.cidWidths != null) {
            Float width = this.cidWidths.get(ech);
            if (width != null) {
                advance = this.cidWidths.get(ech).floatValue() * this.awtFont.getSize2D();
            }
        } else if (this.missingWidth > 0.0f) {
            advance = this.missingWidth / 1000.0f;
        }
        return new Point2D.Float(advance, advanceY);
    }

    private char getCMapping(char currentChar) {
        if (this.toUnicode != null) {
            return this.toUnicode.toSelector(currentChar);
        }
        return currentChar;
    }

    public char getCharDiff(char character) {
        if (this.cMap != null && character < this.cMap.length) {
            return this.cMap[character];
        }
        return character;
    }

    private char findAlternateSymbol(char character) {
        for (int i = 0; i < Encoding.symbolAlaises.length; ++i) {
            for (int j = 0; j < Encoding.symbolAlaises[i].length; ++j) {
                if (Encoding.symbolAlaises[i][j] != character) continue;
                return (char)Encoding.symbolAlaises[i][0];
            }
        }
        return character;
    }

    @Override
    public CMap getToUnicode() {
        return this.toUnicode;
    }

    @Override
    public int getStyle() {
        return this.awtFont.getStyle();
    }

    @Override
    public String getFamily() {
        return this.awtFont.getFamily();
    }

    @Override
    public float getSize() {
        return this.awtFont.getSize();
    }

    @Override
    public double getAscent() {
        return this.ascent;
    }

    @Override
    public double getDescent() {
        return this.descent;
    }

    @Override
    public Rectangle2D getMaxCharBounds() {
        return this.maxCharBounds;
    }

    @Override
    public AffineTransform getTransform() {
        return this.awtFont.getTransform();
    }

    @Override
    public int getRights() {
        return 0;
    }

    @Override
    public String getName() {
        return this.awtFont.getName();
    }

    @Override
    public boolean isHinted() {
        return false;
    }

    @Override
    public int getNumGlyphs() {
        return this.awtFont.getNumGlyphs();
    }

    @Override
    public char getSpaceEchar() {
        return ' ';
    }

    @Override
    public Rectangle2D getEstringBounds(String estr, int beginIndex, int limit) {
        return null;
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public void drawEstring(Graphics2D g, String displayText, float x, float y, long layout, int mode, Color strokecolor) {
        displayText = this.toUnicode(displayText);
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
        GlyphVector glyphVector = this.awtFont.createGlyphVector(frc, displayText);
        glyphVector.setGlyphPosition(0, new Point2D.Float(x, y));
        int displayLength = displayText.length();
        if (displayLength > 1) {
            float advance = 0.0f;
            for (int i = 0; i < displayText.length(); ++i) {
                Point2D p = glyphVector.getGlyphPosition(i);
                float lastx = (float)p.getX();
                glyphVector.setGlyphPosition(i, new Point2D.Double(lastx + advance, p.getY()));
                float adv1 = glyphVector.getGlyphMetrics(i).getAdvance();
                double adv2 = this.echarAdvance(displayText.charAt(i)).getX();
                advance = (float)((double)advance + ((double)(-adv1) + adv2 + (double)lastx));
            }
        }
        if (0 == mode || 2 == mode || 4 == mode || 6 == mode) {
            g.fill(glyphVector.getOutline());
        }
        if (1 == mode || 2 == mode || 5 == mode || 6 == mode) {
            g.draw(glyphVector.getOutline());
        }
    }

    @Override
    public String toUnicode(String displayText) {
        StringBuilder sb = new StringBuilder(displayText.length());
        for (int i = 0; i < displayText.length(); ++i) {
            sb.append(this.toUnicode(displayText.charAt(i)));
        }
        return sb.toString();
    }

    @Override
    public String toUnicode(char c1) {
        char c;
        char c2 = c = this.toUnicode == null ? this.getCharDiff(c1) : c1;
        if (this.toUnicode != null) {
            return this.toUnicode.toUnicode(c);
        }
        if (!this.awtFont.canDisplay(c = this.getCMapping(c))) {
            c = (char)(c | 0xF000);
        }
        if (!this.awtFont.canDisplay(c)) {
            c = this.findAlternateSymbol(c);
        }
        if (log.isLoggable(Level.FINER) && !this.awtFont.canDisplay(c)) {
            log.finer(c1 + " " + Character.toString(c1) + " " + c + " " + c + " " + this.awtFont);
        }
        return String.valueOf(c);
    }

    @Override
    public boolean isOneByteEncoding() {
        return false;
    }
}

