/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.MemoryManageable;
import org.icepdf.core.util.MemoryManagerDelegate;

public class MemoryManager {
    private static final Logger logger = Logger.getLogger(MemoryManager.class.toString());
    private static MemoryManager instance;
    protected final Runtime runtime = Runtime.getRuntime();
    protected long minMemory = 300000L;
    protected long maxMemory = this.runtime.maxMemory();
    protected int purgeSize;
    protected int maxSize;
    protected WeakHashMap<Object, HashSet<MemoryManageable>> locked;
    protected ArrayList<MemoryManageable> leastRecentlyUsed;
    protected long cumulativeDurationManagingMemory;
    protected long cumulativeDurationNotManagingMemory;
    protected long previousTimestampManagedMemory;
    protected int percentageDurationManagingMemory;
    protected ArrayList<MemoryManagerDelegate> delegates;

    public static MemoryManager getInstance() {
        if (instance == null) {
            instance = new MemoryManager();
        }
        return instance;
    }

    protected MemoryManager() {
        try {
            int t = MemoryManager.parse("org.icepdf.core.minMemory");
            if (t > 0) {
                this.minMemory = t;
            }
        }
        catch (Throwable e) {
            logger.log(Level.FINE, "Error setting org.icepdf.core.minMemory");
        }
        this.purgeSize = Defs.sysPropertyInt("org.icepdf.core.purgeSize", 5);
        this.maxSize = Defs.sysPropertyInt("org.icepdf.core.maxSize", 0);
        this.locked = new WeakHashMap();
        this.leastRecentlyUsed = new ArrayList(256);
        this.delegates = new ArrayList(64);
    }

    public synchronized void lock(Object user, MemoryManageable mm) {
        int numUsed;
        int numUsedMoreThanShould;
        if (user == null || mm == null) {
            return;
        }
        HashSet<MemoryManageable> inUse = this.locked.get(user);
        if (inUse == null) {
            inUse = new HashSet(256);
            this.locked.put(user, inUse);
        }
        inUse.add(mm);
        this.leastRecentlyUsed.remove(mm);
        this.leastRecentlyUsed.add(mm);
        if (this.maxSize > 0 && (numUsedMoreThanShould = (numUsed = this.leastRecentlyUsed.size()) - this.maxSize) > 0) {
            int numToDo = Math.max(this.purgeSize, numUsedMoreThanShould);
            this.reduceMemory(numToDo);
        }
    }

    public synchronized void release(Object user, MemoryManageable mm) {
        if (user == null || mm == null) {
            return;
        }
        HashSet<MemoryManageable> inUse = this.locked.get(user);
        if (inUse != null) {
            boolean removed = inUse.remove(mm);
            if (inUse.size() == 0) {
                this.locked.remove(user);
            }
        }
    }

    public synchronized void registerMemoryManagerDelegate(MemoryManagerDelegate delegate) {
        if (!this.delegates.contains(delegate)) {
            this.delegates.add(delegate);
        }
    }

    public synchronized void releaseAllByLibrary(Library library) {
        if (library == null) {
            return;
        }
        for (int i = this.leastRecentlyUsed.size() - 1; i >= 0; --i) {
            MemoryManageable mm = this.leastRecentlyUsed.get(i);
            Library lib = mm.getLibrary();
            if (lib == null || !lib.equals(library)) continue;
            this.leastRecentlyUsed.remove(i);
        }
        ArrayList<Object> usersToRemove = new ArrayList<Object>();
        Set<Map.Entry<Object, HashSet<MemoryManageable>>> entries = this.locked.entrySet();
        Iterator<Map.Entry<Object, HashSet<MemoryManageable>>> i$ = entries.iterator();
        while (i$.hasNext()) {
            Map.Entry<Object, HashSet<MemoryManageable>> entry;
            Map.Entry<Object, HashSet<MemoryManageable>> entry2 = entry = i$.next();
            Object user = entry2.getKey();
            HashSet<MemoryManageable> inUse = entry2.getValue();
            if (inUse == null) continue;
            ArrayList<MemoryManageable> mmsToRemove = new ArrayList<MemoryManageable>();
            for (MemoryManageable anInUse : inUse) {
                Library lib;
                MemoryManageable mm = anInUse;
                if (mm == null || (lib = mm.getLibrary()) == null || !lib.equals(library)) continue;
                mmsToRemove.add(mm);
            }
            for (MemoryManageable aMmsToRemove : mmsToRemove) {
                inUse.remove(aMmsToRemove);
            }
            mmsToRemove.clear();
            if (inUse.size() != 0) continue;
            usersToRemove.add(user);
        }
        for (Map.Entry<Object, HashSet<MemoryManageable>> entry : usersToRemove) {
            this.locked.remove(entry);
        }
        usersToRemove.clear();
        for (int i = this.delegates.size() - 1; i >= 0; --i) {
            MemoryManagerDelegate memoryManagerDelegate = this.delegates.get(i);
            boolean shouldRemove = false;
            if (memoryManagerDelegate == null) {
                shouldRemove = true;
            } else {
                Library lib = memoryManagerDelegate.getLibrary();
                if (lib == null) {
                    shouldRemove = true;
                } else if (lib.equals(library)) {
                    shouldRemove = true;
                }
            }
            if (!shouldRemove) continue;
            this.delegates.remove(i);
        }
    }

    protected synchronized boolean reduceMemory() {
        int numToDo = this.purgeSize;
        int aggressive = 0;
        int lruSize = this.leastRecentlyUsed.size();
        if (this.percentageDurationManagingMemory > 15 || lruSize > 100) {
            aggressive = lruSize * 60 / 100;
        } else if (lruSize > 50) {
            aggressive = lruSize * 50 / 100;
        } else if (lruSize > 20) {
            aggressive = lruSize * 40 / 100;
        }
        if (aggressive > numToDo) {
            numToDo = aggressive;
        }
        int numDone = this.reduceMemory(numToDo);
        boolean delegatesReduced = false;
        if (numDone == 0) {
            delegatesReduced = this.reduceMemoryWithDelegates(true);
        } else if (numDone < numToDo) {
            delegatesReduced = this.reduceMemoryWithDelegates(false);
        }
        return numDone > 0 || delegatesReduced;
    }

    protected int reduceMemory(int numToDo) {
        int numDone = 0;
        try {
            int leastRecentlyUsedIndex = 0;
            while (numDone < numToDo && leastRecentlyUsedIndex < this.leastRecentlyUsed.size()) {
                MemoryManageable mm = this.leastRecentlyUsed.get(leastRecentlyUsedIndex);
                if (!this.isLocked(mm)) {
                    mm.reduceMemory();
                    ++numDone;
                    this.leastRecentlyUsed.remove(leastRecentlyUsedIndex);
                    continue;
                }
                ++leastRecentlyUsedIndex;
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Problem while reducing memory", e);
        }
        return numDone;
    }

    protected synchronized boolean isLocked(MemoryManageable mm) {
        Set<Map.Entry<Object, HashSet<MemoryManageable>>> entries = this.locked.entrySet();
        for (Map.Entry<Object, HashSet<MemoryManageable>> entry1 : entries) {
            Map.Entry<Object, HashSet<MemoryManageable>> entry = entry1;
            HashSet<MemoryManageable> inUse = entry.getValue();
            if (inUse == null || !inUse.contains(mm)) continue;
            return true;
        }
        return false;
    }

    protected synchronized boolean reduceMemoryWithDelegates(boolean aggressively) {
        int reductionPolicy = aggressively ? 1 : 0;
        boolean anyReduced = false;
        for (MemoryManagerDelegate mmd : this.delegates) {
            if (mmd == null) continue;
            boolean reduced = mmd.reduceMemory(reductionPolicy);
            anyReduced |= reduced;
        }
        return anyReduced;
    }

    private static int parse(String memoryValue) {
        String s = Defs.sysProperty(memoryValue);
        if (s == null) {
            return -1;
        }
        int mult = 1;
        char c = s.charAt(s.length() - 1);
        if (c == 'k' || c == 'K') {
            mult = 1024;
            s = s.substring(0, s.length() - 1);
        }
        if (c == 'm' || c == 'M') {
            mult = 0x100000;
            s = s.substring(0, s.length() - 1);
        }
        return mult * Integer.parseInt(s);
    }

    public void setMinMemory(long m) {
        this.minMemory = m;
    }

    public long getMinMemory() {
        return this.minMemory;
    }

    public long getFreeMemory() {
        return this.runtime.freeMemory();
    }

    private boolean canAllocate(int bytes, boolean doGC) {
        long mem = this.runtime.freeMemory();
        if (mem - (long)bytes > this.minMemory) {
            return true;
        }
        long total = this.runtime.totalMemory();
        if (this.maxMemory > total && (mem += this.maxMemory - total) - (long)bytes > this.minMemory) {
            return true;
        }
        if (!doGC) {
            return false;
        }
        this.reduceMemory();
        System.gc();
        mem = this.runtime.freeMemory();
        if (mem - (long)bytes > this.minMemory) {
            return true;
        }
        System.runFinalization();
        System.gc();
        mem = this.runtime.freeMemory();
        return mem - (long)bytes > this.minMemory;
    }

    public boolean isLowMemory() {
        return !this.canAllocate(0, true);
    }

    public boolean checkMemory(int memoryNeeded) {
        long beginTime = System.currentTimeMillis();
        int count = 0;
        while (!this.canAllocate(memoryNeeded, count > 0)) {
            boolean reducedSomething = this.reduceMemory();
            if (!reducedSomething && count > 0) {
                this.finishedMemoryProcessing(beginTime);
                return false;
            }
            if (++count <= 10) continue;
            this.finishedMemoryProcessing(beginTime);
            return false;
        }
        this.finishedMemoryProcessing(beginTime);
        return true;
    }

    private void finishedMemoryProcessing(long beginTime) {
        long endTime = System.currentTimeMillis();
        long duration = endTime - beginTime;
        if (duration > 0L) {
            this.cumulativeDurationManagingMemory += duration;
        }
        if (this.previousTimestampManagedMemory != 0L && (duration = beginTime - this.previousTimestampManagedMemory) > 0L) {
            this.cumulativeDurationNotManagingMemory += duration;
        }
        this.previousTimestampManagedMemory = endTime;
        long totalDuration = this.cumulativeDurationManagingMemory + this.cumulativeDurationNotManagingMemory;
        if (totalDuration > 0L) {
            this.percentageDurationManagingMemory = (int)(this.cumulativeDurationManagingMemory * 100L / totalDuration);
        }
    }
}

