/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.json.value.impl;

import org.exoplatform.ws.frameworks.json.JsonWriter;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonUtils;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

public class StringValue
extends JsonValue {
    private final String value;

    public StringValue(String value) {
        this.value = value;
    }

    public boolean isString() {
        return true;
    }

    public String getStringValue() {
        return this.value;
    }

    public boolean getBooleanValue() {
        return Boolean.parseBoolean(this.value);
    }

    public Number getNumberValue() {
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public byte getByteValue() {
        return this.getNumberValue().byteValue();
    }

    public short getShortValue() {
        return this.getNumberValue().shortValue();
    }

    public int getIntValue() {
        return this.getNumberValue().intValue();
    }

    public long getLongValue() {
        return this.getNumberValue().longValue();
    }

    public float getFloatValue() {
        return this.getNumberValue().floatValue();
    }

    public double getDoubleValue() {
        return this.getNumberValue().doubleValue();
    }

    public String toString() {
        return JsonUtils.getJsonString(this.value);
    }

    public void writeTo(JsonWriter writer) throws JsonException {
        writer.writeString(this.value);
    }
}

