/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import java.io.InputStream;
import java.net.URL;
import javax.servlet.ServletContext;
import org.exoplatform.commons.xml.DocumentSource;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.resource.config.xml.SkinConfigParser;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.wci.WebAppEvent;
import org.gatein.wci.WebAppLifeCycleEvent;
import org.gatein.wci.WebAppListener;

public class GateInSkinConfigDeployer
implements WebAppListener {
    private static final Logger log = LoggerFactory.getLogger(GateInSkinConfigDeployer.class);
    private final SkinService skinService;
    private static final String GATEIN_CONFIG_RESOURCE = "/WEB-INF/gatein-resources.xml";
    private final String portalContainerName;

    public GateInSkinConfigDeployer(String portalContainerName, SkinService _skinService) {
        this.skinService = _skinService;
        this.portalContainerName = portalContainerName;
    }

    public void onEvent(WebAppEvent event) {
        WebAppLifeCycleEvent waEvent;
        if (event instanceof WebAppLifeCycleEvent && (waEvent = (WebAppLifeCycleEvent)event).getType() == 1) {
            ServletContext scontext = null;
            try {
                scontext = event.getWebApp().getServletContext();
                InputStream is = scontext.getResourceAsStream(GATEIN_CONFIG_RESOURCE);
                if (is == null) {
                    return;
                }
                try {
                    is.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                RootContainer.PortalContainerPostInitTask task = new RootContainer.PortalContainerPostInitTask(){

                    public void execute(ServletContext scontext, PortalContainer portalContainer) {
                        GateInSkinConfigDeployer.this.register(scontext, portalContainer);
                        GateInSkinConfigDeployer.this.skinService.registerContext(scontext);
                    }
                };
                PortalContainer.addInitTask((ServletContext)scontext, (RootContainer.PortalContainerInitTask)task, (String)this.portalContainerName);
            }
            catch (Exception ex) {
                log.error((Object)("An error occurs while registering '/WEB-INF/gatein-resources.xml' from the context '" + (scontext == null ? "unknown" : scontext.getServletContextName()) + "'"), (Throwable)ex);
            }
        }
    }

    private void register(ServletContext scontext, PortalContainer container) {
        try {
            URL url = scontext.getResource(GATEIN_CONFIG_RESOURCE);
            if (url != null) {
                SkinConfigParser.processConfigResource(DocumentSource.create((URL)url), this.skinService, scontext);
            } else {
                log.debug((Object)("No /WEB-INF/gatein-resources.xml found in web application " + scontext.getContextPath()));
            }
        }
        catch (Exception ex) {
            log.error((Object)("An error occurs while registering '/WEB-INF/gatein-resources.xml' from the context '" + (scontext == null ? "unknown" : scontext.getServletContextName()) + "'"), (Throwable)ex);
        }
    }
}

