/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import org.exoplatform.portal.resource.SkinConfig;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.resource.SkinURL;
import org.exoplatform.services.resources.Orientation;

class SimpleSkin
implements SkinConfig {
    private final SkinService service_;
    private final String module_;
    private final String name_;
    private final String cssPath_;
    private final String id_;
    private final int priority;

    public SimpleSkin(SkinService service, String module, String name, String cssPath) {
        this(service, module, name, cssPath, Integer.MAX_VALUE);
    }

    public SimpleSkin(SkinService service, String module, String name, String cssPath, int cssPriority) {
        this.service_ = service;
        this.module_ = module;
        this.name_ = name;
        this.cssPath_ = cssPath;
        this.id_ = module.replace('/', '_');
        this.priority = cssPriority;
    }

    public int getCSSPriority() {
        return this.priority;
    }

    public String getId() {
        return this.id_;
    }

    public String getModule() {
        return this.module_;
    }

    public String getCSSPath() {
        return this.cssPath_;
    }

    public String getName() {
        return this.name_;
    }

    public String toString() {
        return "SimpleSkin[id=" + this.id_ + ",module=" + this.module_ + ",name=" + this.name_ + ",cssPath=" + this.cssPath_ + ", priority=" + this.priority + "]";
    }

    public SkinURL createURL() {
        return new SkinURL(){
            Orientation orientation = null;

            public void setOrientation(Orientation orientation) {
                this.orientation = orientation;
            }

            public String toString() {
                return SimpleSkin.this.cssPath_.replaceAll("\\.css$", SimpleSkin.this.service_.getSuffix(this.orientation));
            }
        };
    }
}

