/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.linter;

import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.js.Declaration;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SymbolTable {
    private final Map<String, Symbol> symbols = Maps.newLinkedHashMap();

    SymbolTable() {
    }

    Symbol getSymbol(String symbolName) {
        return this.symbols.get(symbolName);
    }

    Collection<String> symbolNames() {
        return Collections.unmodifiableSet(this.symbols.keySet());
    }

    void declare(AncestorChain<Declaration> decl) {
        this.declare(((Declaration)decl.node).getIdentifierName(), decl);
    }

    void declare(String symbolName, AncestorChain<?> decl) {
        Symbol s = this.symbols.get(symbolName);
        if (s == null) {
            s = new Symbol();
            this.symbols.put(symbolName, s);
        }
        s.decls.add(decl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Symbol {
        private final Collection<AncestorChain<?>> decls = Lists.newArrayList();

        Symbol() {
        }

        Collection<AncestorChain<?>> getDeclarations() {
            return Collections.unmodifiableCollection(this.decls);
        }
    }
}

