/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.servlet;

import com.google.caja.util.ContentType;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

final class Content {
    private final String codeUnits;
    private byte[] bytes;
    final ContentType type;

    Content(String codeUnits, ContentType type) {
        assert (type == null || type.isText);
        if (codeUnits == null) {
            throw new NullPointerException();
        }
        this.codeUnits = codeUnits;
        this.bytes = null;
        this.type = type;
    }

    Content(byte[] bytes, ContentType type) {
        assert (type == null || !type.isText);
        if (bytes == null) {
            throw new NullPointerException();
        }
        this.codeUnits = null;
        this.bytes = bytes;
        this.type = type;
    }

    void toWriter(Writer w) throws IOException {
        if (this.codeUnits == null) {
            throw new IOException("Cannot write byte data");
        }
        w.write(this.codeUnits);
    }

    void toOutputStream(OutputStream o) throws IOException {
        if (this.bytes != null) {
            o.write(this.bytes);
        } else {
            OutputStreamWriter w = new OutputStreamWriter(o, "UTF-8");
            this.toWriter(w);
            ((Writer)w).flush();
        }
    }

    long byteLength() {
        if (this.bytes == null) {
            try {
                this.bytes = this.codeUnits.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.bytes.length;
    }

    String getText() throws IOException {
        if (this.codeUnits == null) {
            throw new IOException("cannot read binary file");
        }
        return this.codeUnits;
    }

    boolean isText() {
        return this.codeUnits != null;
    }
}

