/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.html;

import com.google.caja.parser.html.Namespaces;
import junit.framework.TestCase;

public class NamespacesTest
extends TestCase {
    Namespaces ns = new Namespaces(new Namespaces(Namespaces.COMMON, "foo", "http://foo.com/bar"), "", "http://empty.string/");

    public final void testNamespaces() {
        NamespacesTest.assertEquals((String)"xmlns", (String)this.ns.forPrefix((String)"xmlns").prefix);
        NamespacesTest.assertEquals((String)"http://www.w3.org/2000/xmlns/", (String)this.ns.forPrefix((String)"xmlns").uri);
        NamespacesTest.assertEquals((String)"xml", (String)this.ns.forPrefix((String)"xml").prefix);
        NamespacesTest.assertEquals((String)"http://www.w3.org/XML/1998/namespace", (String)this.ns.forPrefix((String)"xml").uri);
        NamespacesTest.assertEquals((String)"html", (String)this.ns.forPrefix((String)"html").prefix);
        NamespacesTest.assertEquals((String)"html", (String)this.ns.forPrefix((String)"html").prefix);
        NamespacesTest.assertEquals((String)"http://www.w3.org/1999/xhtml", (String)this.ns.forPrefix((String)"html").uri);
        NamespacesTest.assertEquals((String)"http://www.w3.org/1999/xhtml", (String)this.ns.forPrefix((String)"html").uri);
        NamespacesTest.assertEquals((String)"http://empty.string/", (String)this.ns.forPrefix((String)"").uri);
        NamespacesTest.assertEquals((String)"", (String)this.ns.forUri((String)"http://empty.string/").prefix);
        NamespacesTest.assertEquals(null, (Object)this.ns.forPrefix("bogus"));
    }

    public final void testElementQNames() {
        NamespacesTest.assertEquals((String)"http://empty.string/", (String)this.ns.forElementName((String)"foo").uri);
        NamespacesTest.assertEquals((String)"http://www.w3.org/XML/1998/namespace", (String)this.ns.forElementName((String)"xml:foo").uri);
    }

    public final void testAttrQNames() {
        NamespacesTest.assertEquals((String)"http://www.w3.org/XML/1998/namespace", (String)this.ns.forAttrName((Namespaces)this.ns.forPrefix((String)"xml"), (String)"foo").uri);
        NamespacesTest.assertEquals((String)"http://www.w3.org/XML/1998/namespace", (String)this.ns.forAttrName((Namespaces)this.ns.forPrefix((String)"xml"), (String)"xml:foo").uri);
        NamespacesTest.assertEquals((String)"http://www.w3.org/1999/xhtml", (String)this.ns.forAttrName((Namespaces)this.ns.forPrefix((String)"xml"), (String)"html:foo").uri);
        NamespacesTest.assertEquals((String)"http://www.w3.org/XML/1998/namespace", (String)this.ns.forAttrName((Namespaces)this.ns.forPrefix((String)"xml"), (String)"foo").uri);
    }

    public final void testPrefixMasking() {
        Namespaces fooMasked = new Namespaces(this.ns, this.ns.prefix, "http://other.com/");
        NamespacesTest.assertEquals((Object)fooMasked, (Object)fooMasked.forUri(fooMasked.uri));
        NamespacesTest.assertEquals((Object)fooMasked, (Object)fooMasked.forPrefix(fooMasked.prefix));
        NamespacesTest.assertEquals(null, (Object)fooMasked.forUri(this.ns.uri));
    }
}

