/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FetchedData;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.parser.js.FormalParam;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.FunctionDeclaration;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.ReturnStmt;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.SyntheticNodes;
import com.google.caja.parser.js.UncajoledModule;
import com.google.caja.parser.quasiliteral.CajitaModuleRewriter;
import com.google.caja.parser.quasiliteral.CajitaRewriter;
import com.google.caja.parser.quasiliteral.CommonJsRewriterTestCase;
import com.google.caja.parser.quasiliteral.DefaultValijaRewriter;
import com.google.caja.parser.quasiliteral.InnocentCodeRewriter;
import com.google.caja.parser.quasiliteral.ModuleManager;
import com.google.caja.parser.quasiliteral.Rewriter;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.reporting.TestBuildInfo;
import com.google.caja.util.Executor;
import com.google.caja.util.FailureIsAnOption;
import com.google.caja.util.RhinoTestBed;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;

public class DefaultValijaRewriterTest
extends CommonJsRewriterTestCase {
    private Rewriter valijaRewriter;
    private CajitaModuleRewriter cajitaModuleRewriter;
    private Rewriter innocentCodeRewriter;

    public void setUp() throws Exception {
        super.setUp();
        this.valijaRewriter = new DefaultValijaRewriter(this.mq, false);
        this.cajitaModuleRewriter = new CajitaModuleRewriter(new TestBuildInfo(), new TestUriFetcher(), true, this.mq);
        this.innocentCodeRewriter = new InnocentCodeRewriter(this.mq, false);
        this.setRewriter(this.valijaRewriter);
    }

    public final void testSyntheticIsUntouched() throws Exception {
        Block input = this.js(this.fromString("function foo() { this; arguments; }"));
        this.syntheticTree(input);
        this.checkSucceeds(input, this.js(this.fromString("var $dis = $v.getOuters();$v.initOuter('onerror');function foo() { this; arguments; }")));
    }

    public final void testSyntheticMemberAccess() throws Exception {
        Block input = this.js(this.fromString("({}).foo"));
        this.syntheticTree(input);
        this.checkSucceeds(input, this.js(this.fromString("var $dis = $v.getOuters();$v.initOuter('onerror');({}).foo")));
    }

    public final void testSyntheticNestedIsExpanded() throws Exception {
        Block innerInput = this.js(this.fromString("function foo() {}"));
        Block input = new Block(FilePosition.UNKNOWN, Arrays.asList(innerInput));
        this.makeSynthetic(input);
        Block expectedResult = this.js(this.fromString("var $dis = $v.getOuters();$v.initOuter('onerror');{  $v.so('foo', (function () {                  var foo;                  function foo$_caller($dis) {}                  foo = $v.dis(foo$_caller, 'foo');                  return foo;                })());;}"));
        this.checkSucceeds(input, expectedResult);
    }

    public final void testSyntheticNestedFunctionIsExpanded() throws Exception {
        Block innerBlock = this.js(this.fromString("foo().x = bar();"));
        Block input = new Block(FilePosition.UNKNOWN, Arrays.asList(new FunctionDeclaration(SyntheticNodes.s(new FunctionConstructor(FilePosition.UNKNOWN, new Identifier(FilePosition.UNKNOWN, "f"), Collections.<FormalParam>emptyList(), innerBlock)))));
        Block expectedResult = this.js(this.fromString("var $dis = $v.getOuters();$v.initOuter('onerror');function f() {  $v.s($v.cf($v.ro('foo'), []), 'x', $v.cf($v.ro('bar'), []));}"));
        this.checkSucceeds(input, expectedResult);
    }

    public final void testSyntheticFormals() throws Exception {
        FilePosition unk = FilePosition.UNKNOWN;
        FunctionConstructor fc = new FunctionConstructor(unk, new Identifier(unk, "f"), Arrays.asList(new FormalParam(new Identifier(unk, "x")), new FormalParam(SyntheticNodes.s(new Identifier(unk, "y___")))), new Block(unk, Arrays.asList(new ReturnStmt(unk, Operation.createInfix(Operator.MULTIPLICATION, Operation.createInfix(Operator.ADDITION, new Reference(new Identifier(unk, "x")), new Reference(SyntheticNodes.s(new Identifier(unk, "y___")))), new Reference(new Identifier(unk, "z")))))));
        this.checkSucceeds(new Block(unk, Arrays.asList(new FunctionDeclaration((FunctionConstructor)fc.clone()))), this.js(this.fromString("var $dis = $v.getOuters();$v.initOuter('onerror');$v.so('f', (function () {  var f;  function f$_caller($dis, x, y___) {    return (x + y___) * $v.ro('z');  }  f = $v.dis(f$_caller, 'f');  return f;})());;")));
        SyntheticNodes.s(fc);
        this.checkSucceeds(new Block(unk, Arrays.asList(new FunctionDeclaration((FunctionConstructor)fc.clone()))), this.js(this.fromString("var $dis = $v.getOuters();$v.initOuter('onerror');function f(x, y___) {  return (x + y___) * $v.ro('z');}")));
    }

    public final void testConstant() throws Exception {
        this.assertConsistent("1;");
    }

    public final void testInit() throws Exception {
        this.assertConsistent("var a = 0; a;");
    }

    public final void testNew() throws Exception {
        this.assertConsistent("function f() { this.x = 1; } f; var g = new f(); g.x;");
    }

    public final void testThrowCatch() throws Exception {
        this.assertConsistent("var x = 0; try { throw 1; }catch (e) { x = e; }x;");
        this.assertConsistent("var x = 0; try { throw { a: 1 }; }catch (e) { x = e; }x;");
        this.assertConsistent("var x = 0; try { throw 'err'; }catch (e) { x = e; }x;");
        this.assertConsistent("var x = 0; try { throw new Error('err'); }catch (e) { x = e.message; }x;");
        this.assertConsistent("var x = 0; try { throw 1; }catch (e) { x = e; }finally { x = 2; }x;");
        this.assertConsistent("var x = 0; try { throw { a: 1 }; }catch (e) { x = e; }finally { x = 2; }x;");
        this.assertConsistent("var x = 0; try { throw 'err'; }catch (e) { x = e; }finally { x = 2; }x;");
        this.assertConsistent("var x = 0; try { throw new Error('err'); }catch (e) { x = e.message; }finally { x = 2; }x;");
    }

    public final void testProtoCall() throws Exception {
        this.assertConsistent("Array.prototype.sort.call([3, 1, 2]);");
        this.assertConsistent("[3, 1, 2].sort();");
        this.assertConsistent("[3, 1, 2].sort.call([4, 2, 7]);");
        this.assertConsistent("String.prototype.indexOf.call('foo', 'o');");
        this.assertConsistent("'foo'.indexOf('o');");
        this.assertConsistent("'foo'.indexOf.call('bar', 'o');");
        this.assertConsistent("'foo'.indexOf.call('bar', 'a');");
    }

    public final void testInherit() throws Exception {
        this.assertConsistent("function Point(x) { this.x = x; }\nPoint.prototype.toString = function () {\n  return '<' + this.x + '>';\n};\nfunction WP(x) { Point.call(this,x); }\nWP.prototype = cajita.beget(Point.prototype);\nvar pt = new WP(3);\npt.toString();");
    }

    public final void testRegExpLeak() throws Exception {
        this.rewriteAndExecute("assertEquals('' + (/(.*)/).exec(), 'undefined,undefined');");
    }

    public final void testClosure() throws Exception {
        this.assertConsistent("function f() {  var y = 2;   this.x = function() {    return y;  }; }var g = new f();var h = {};f.call(h);h.y = g.x;h.x() + h.y();");
    }

    public final void testNamedFunctionShadow() throws Exception {
        this.assertConsistent("function f() { return f; } f === f();");
        this.assertConsistent("(function () { function f() { return f; } return f === f(); })();");
    }

    public final void testArray() throws Exception {
        this.assertConsistent("[3, 2, 1].sort();");
        this.assertConsistent("[3, 2, 1].sort.call([4, 2, 7]);");
    }

    public final void testObject() throws Exception {
        this.assertConsistent("({ x: 1, y: 2 });");
    }

    public final void testIndexOf() throws Exception {
        this.assertConsistent("'foo'.indexOf('o');");
    }

    public final void testFunctionToStringCall() throws Exception {
        this.rewriteAndExecute("function foo() {}\nassertEquals(foo.toString(),\n             'function foo() {\\n  [cajoled code]\\n}');");
        this.rewriteAndExecute("function foo (a, b) { xx; }\nassertEquals(foo.toString(),\n             'function foo(a, b) {\\n  [cajoled code]\\n}');");
        this.rewriteAndExecute("function foo() {}\nassertEquals(Function.prototype.toString.call(foo),\n             'function foo() {\\n  [cajoled code]\\n}');");
        this.rewriteAndExecute("var foo = function (x$x, y_y) {};\nassertEquals(Function.prototype.toString.call(foo),\n             'function foo$_var(x$x, y_y) {\\n  [cajoled code]\\n}');");
    }

    public final void testUnderscore() throws Exception {
        this.rewriteAndExecute("var msg;try {  var x__ = 1;  x__;} catch (ex) {  msg = ex.message;}assertEquals('Not writable: ([Object]).x__', msg);");
    }

    public final void testDate() throws Exception {
        this.assertConsistent("(new Date(0)).getTime();");
        this.assertConsistent("'' + (new Date(0));");
        this.rewriteAndExecute("var time = (new Date - 1);assertFalse(isNaN(time));assertEquals('number', typeof time);");
    }

    public final void testMultiDeclaration2() throws Exception {
        this.rewriteAndExecute("var a, b, c;");
        this.rewriteAndExecute("var a = 0, b = ++a, c = ++a;assertEquals(++a * b / c, 1.5);");
    }

    public final void testDelete() throws Exception {
        this.assertConsistent("(function () { var a = { x: 1 }; delete a.x; return typeof a.x; })();");
        this.assertConsistent("var a = { x: 1 }; delete a.x; typeof a.x;");
    }

    public final void testIn2() throws Exception {
        this.assertConsistent("(function () {  var a = { x: 1 };\n  return '' + ('x' in a) + ('y' in a);})();");
        this.assertConsistent("var a = { x: 1 };\n[('x' in a), ('y' in a)];");
    }

    public final void testForIn2() throws Exception {
        this.assertConsistent("(function () {  var str = '';  for (i in { x: 1, y: true }) { str += i; }  return str;})();");
        this.assertConsistent("(function () {  var str = '';  for (var i in { x: 1, y: true }) { str += i; } return str;})();");
        this.assertConsistent("str = ''; for (i in { x: 1, y: true }) { str += i; } str;");
        this.assertConsistent("str = ''; for (var i in { x: 1, y: true }) { str += i; } str;");
    }

    public final void testValueOf() throws Exception {
        this.rewriteAndExecute("var msg;try {  var k = 'valueOf';  var o = {};  o[k] = function (hint) { return 2; };} catch (ex) {  msg = ex.message;}assertEquals('Not writable: ([Object]).valueOf', msg);");
    }

    public final void testWrapperAccess() throws Exception {
        this.rewriteAndExecute("", "x = 'test';", "if (___.getNewModuleHandler().getImports().x != 'test') {fail('Cannot see inside the wrapper');}");
    }

    public final void testFuncCtor() throws Exception {
        this.rewriteAndExecute("function Foo(x) { this.x = x; }var foo = new Foo(2);if (!foo) { fail('Failed to construct a global object.'); }assertEquals(foo.x, 2);");
        this.rewriteAndExecute("(function () {  function Foo(x) { this.x = x; }  var foo = new Foo(2);  if (!foo) { fail('Failed to construct a local object.'); }  assertEquals(foo.x, 2);})();");
        this.rewriteAndExecute("function Foo() { }var foo = new Foo();if (!foo) {  fail('Failed to use a simple named function as a constructor.');}");
    }

    public final void testFuncArgs() throws Exception {
        this.rewriteAndExecute("var x = 0;function f() { x = arguments[0]; }f(3);assertEquals(3, x);");
    }

    public final void testStatic() throws Exception {
        this.assertConsistent("Array.slice([3, 4, 5, 6], 1);");
    }

    public final void testConcatArgs() throws Exception {
        this.rewriteAndExecute("", "(function(x, y){ return [x, y]; })", "var f = ___.getNewModuleHandler().getLastValue();function g(var_args) { return f.apply(___.USELESS, arguments); }assertEquals(g(3, 4).toString(), [3, 4].toString());");
    }

    public final void testReformedGenerics() throws Exception {
        this.assertConsistent("var x = [33];x.foo = [].push;x.foo(44);x;");
        this.assertConsistent("var x = {blue:'green'};x.foo = [].push;x.foo(44);cajita.getOwnPropertyNames(x).sort();");
        this.assertConsistent("var x = [33];Array.prototype.push.apply(x, [3,4,5]);x;");
        this.assertConsistent("var x = {blue:'green'};Array.prototype.push.apply(x, [3,4,5]);cajita.getOwnPropertyNames(x).sort();");
    }

    public final void testCallback() throws Exception {
        this.assertConsistent("Function.prototype.apply.call(function(a, b) {return a + b;}, {}, [3, 4]);");
        this.assertConsistent("Function.prototype.call.call(function(a, b) {return a + b;}, {}, 3, 4);");
        this.assertConsistent("Function.prototype.bind.call(function(a, b) {return a + b;}, {}, 3)(4);");
    }

    public final void testMonkeyPatchPrimordialFunction() throws Exception {
        this.assertConsistent("isNaN.foo = 'bar';isNaN.foo;");
    }

    public final void testFuncNaming() throws Exception {
        this.checkSucceeds("function foo(){debugger;}var x = {bar: function() {foo();}};x.baz = function(){x.bar();};var zip = function(){  var lip = function(){x.baz();};  var lap;  lap = function(){lip();};  lap();};var zap;zap = function(){zip();};zap();", "var $dis = $v.getOuters();$v.initOuter('onerror');$v.so('foo', (function () {  var foo;  function foo$_caller($dis) { debugger; }  foo = $v.dis(foo$_caller, 'foo');  return foo;})());;$v.so('x',{  'bar': (function () {    function bar$_lit$($dis) {      $v.cf($v.ro('foo'), []);    }    var bar$_lit = $v.dis(bar$_lit$, 'bar$_lit');    return bar$_lit;  })()});$v.s($v.ro('x'), 'baz', (function () {  function baz$_meth$($dis) {    $v.cm($v.ro('x'), 'bar', []);  }  var baz$_meth = $v.dis(baz$_meth$, 'baz$_meth');  return baz$_meth;})());$v.so('zip', (function () {  function zip$_var$($dis) {    var lip = (function () {      function lip$_var$($dis) {        $v.cm($v.ro('x'), 'baz', [ ]);      }      var lip$_var = $v.dis(lip$_var$, 'lip$_var');      return lip$_var;    })();    var lap;    lap = (function () {      function lap$_var$($dis) {        $v.cf(lip, [ ]);      }      var lap$_var = $v.dis(lap$_var$, 'lap$_var');      return lap$_var;    })();    $v.cf(lap, [ ]);  }  var zip$_var = $v.dis(zip$_var$, 'zip$_var');  return zip$_var;})());$v.initOuter('zap');$v.so('zap', (function () {  function zap$_var$($dis) {    $v.cf($v.ro('zip'), [ ]);  }  var zap$_var = $v.dis(zap$_var$, 'zap$_var');  return zap$_var;})());$v.cf($v.ro('zap'), [ ]);");
    }

    @FailureIsAnOption
    public final void testInMonkeyDelete() throws Exception {
        this.assertConsistent("delete Array.prototype.push;('push' in []);");
    }

    @FailureIsAnOption
    public final void testMonkeyOverride() throws Exception {
        this.assertConsistent("Date.prototype.propertyIsEnumerable = function(p) { return true; };(new Date()).propertyIsEnumerable('foo');");
    }

    public final void testValijaTypeofConsistent() throws Exception {
        this.assertConsistent("[  (typeof [].push)];");
    }

    public final void testEmbeddedCajita() throws Exception {
        this.assertConsistent("\"use strict,cajita\"; \nvar foo; \n(function () { \n  foo = function () { return 8; }; \n})(); \nfoo();");
    }

    public final void testStaticModuleLoading() throws Exception {
        this.rewriteAndExecute("includeScript('x');assertEquals(x, 3);");
    }

    public final void testErrorFreeze() throws Exception {
        this.rewriteAndExecute("try {  throw new Error('foo');} catch (ex) {  assertFalse(cajita.isFrozen(ex));}");
    }

    public final void testObjectFreeze() throws Exception {
        this.rewriteAndExecute("var r = Object.freeze({});assertThrows(function(){r.foo = 8;});");
        this.rewriteAndExecute("var f = function(){};f.foo = 8;");
        this.rewriteAndExecute("var f = function(){'use cajita';};f.foo = 8;");
        this.rewriteAndExecute("var f = Object.freeze(function(){});assertThrows(function(){f.foo = 8;});");
        this.rewriteAndExecute("var f = Object.freeze(function(){'use cajita';});assertThrows(function(){f.foo = 8;});");
        this.rewriteAndExecute("function Point(x,y) {  this.x = x;  this.y = y;}___.markCtor(Point, Object, 'Point');testImports.pt = new Point(3,5);___.grantSet(testImports.pt, 'x');", "pt.x = 8;assertThrows(function(){Object.freeze(pt);});", "");
        this.rewriteAndExecute("function Point(x,y) {  this.x = x;  this.y = y;}var pt = new Point(3,5);pt.x = 8;Object.freeze(pt);assertThrows(function(){pt.y = 9;});");
    }

    protected Object executePlain(String caja) throws IOException, ParseException {
        this.mq.getMessages().clear();
        Rewriter old = this.getRewriter();
        this.setRewriter(this.innocentCodeRewriter);
        Statement innocentTree = (Statement)this.rewriteTopLevelNode(this.js(this.fromString(caja, this.is)));
        this.setRewriter(old);
        return RhinoTestBed.runJs(new Executor.Input(((Object)((Object)this)).getClass(), "../../../../../js/json_sans_eval/json_sans_eval.js"), new Executor.Input(((Object)((Object)this)).getClass(), "/com/google/caja/cajita.js"), new Executor.Input(((Object)((Object)this)).getClass(), "../../../../../js/jsunit/2.2/jsUnitCore.js"), new Executor.Input(DefaultValijaRewriterTest.render(innocentTree), this.getName() + "-uncajoled"));
    }

    protected Object rewriteAndExecute(String pre, String caja, String post) throws IOException, ParseException {
        this.mq.getMessages().clear();
        Rewriter old = this.getRewriter();
        this.setRewriter(this.valijaRewriter);
        Block valijaTree = this.js(this.fromString(caja, this.is));
        Block cajitaTree = (Block)this.rewriteTopLevelNode(valijaTree);
        CajoledModule cajoled = this.cajoleModule(new UncajoledModule(cajitaTree));
        String cajoledJs = DefaultValijaRewriterTest.render(cajoled);
        CajoledModule valijaBody = this.cajoleModule(new UncajoledModule(this.js(this.fromResource("../../valija-cajita.js"))));
        String valijaCajoled = DefaultValijaRewriterTest.render(valijaBody);
        this.setRewriter(old);
        this.assertNoErrors();
        Object result = RhinoTestBed.runJs(new Executor.Input(((Object)((Object)this)).getClass(), "/com/google/caja/plugin/console-stubs.js"), new Executor.Input(((Object)((Object)this)).getClass(), "../../../../../js/json_sans_eval/json_sans_eval.js"), new Executor.Input(((Object)((Object)this)).getClass(), "/com/google/caja/cajita.js"), new Executor.Input(((Object)((Object)this)).getClass(), "/com/google/caja/cajita-promise.js"), new Executor.Input(((Object)((Object)this)).getClass(), "../../../../../js/jsunit/2.2/jsUnitCore.js"), new Executor.Input(((Object)((Object)this)).getClass(), "/com/google/caja/log-to-console.js"), new Executor.Input("var testImports = ___.copy(___.sharedImports);\ntestImports.Q = Q;testImports.loader = ___.freeze({\n        provide: ___.markFuncFreeze(\n            function(v){ valijaMaker = v; })\n    });\ntestImports.outers = ___.copy(___.sharedImports);\n___.getNewModuleHandler().setImports(testImports);", this.getName() + "valija-setup"), new Executor.Input(valijaCajoled, "valija-cajoled"), new Executor.Input("testImports = ___.copy(___.sharedImports);\ntestImports.Q = Q;testImports.env = {x: 6};testImports.console = console;testImports.assertEquals = assertEquals;___.grantFunc(testImports, 'assertEquals');testImports.assertTrue = assertTrue;___.grantFunc(testImports, 'assertTrue');testImports.assertFalse = assertFalse;___.grantFunc(testImports, 'assertFalse');testImports.assertThrows = function(func, opt_msg) {  assertThrows(___.toFunc(func), opt_msg);};___.grantFunc(testImports, 'assertThrows');testImports.fail = fail;___.grantFunc(testImports, 'fail');testImports.$v = valijaMaker.CALL___(testImports);\n___.getNewModuleHandler().setImports(testImports);", this.getName() + "-test-fixture"), new Executor.Input(pre, this.getName() + "-pre"), new Executor.Input(cajoledJs, this.getName() + "-cajoled"), new Executor.Input(post, this.getName() + "-post"), new Executor.Input("___.getNewModuleHandler().getLastValue();", this.getName()));
        this.assertNoErrors();
        return result;
    }

    private CajoledModule cajoleModule(UncajoledModule m) {
        URI baseUri = URI.create("resource:///com/google/caja/parser/quasiliteral/");
        CajitaModuleRewriter rw = this.cajitaModuleRewriter;
        ModuleManager mm = rw.getModuleManager();
        ParseTreeNode expanded = new CajitaRewriter(baseUri, mm, false).expand(m);
        CajoledModule cm = (CajoledModule)expanded;
        return this.cajitaModuleRewriter.rewrite(Collections.singletonList(cm));
    }

    protected class TestUriFetcher
    implements UriFetcher {
        protected TestUriFetcher() {
        }

        public FetchedData fetch(ExternalReference ref, String mimeType) throws UriFetcher.UriFetchException {
            try {
                URI uri = ref.getReferencePosition().source().getUri().resolve(ref.getUri());
                if ("resource".equals(uri.getScheme())) {
                    return DefaultValijaRewriterTest.this.dataFromResource(uri.getPath(), new InputSource(uri));
                }
                throw new UriFetcher.UriFetchException(ref, mimeType);
            }
            catch (IOException ex) {
                throw new UriFetcher.UriFetchException(ref, mimeType, ex);
            }
        }
    }
}

