/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.lexer.InputSource;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParseTreeNodeContainer;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.FormalParam;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.IntegerLiteral;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.ReturnStmt;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.parser.quasiliteral.QuasiNode;
import com.google.caja.util.CajaTestCase;
import java.net.URI;
import java.util.Map;

public class MatchTest
extends CajaTestCase {
    private Map<String, ParseTreeNode> m;

    public final void testExactMatch() throws Exception {
        String code = "function foo() { var a = b; }";
        this.match(code, code);
        MatchTest.assertNotNull(this.m);
        this.match(code, "function bar() { var c = d; }");
        MatchTest.assertNull(this.m);
    }

    public final void testSingleHole() throws Exception {
        this.match("x; @a;", "x;");
        MatchTest.assertNull(this.m);
        this.match("x; @a;", "x; x;");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertEquals(ExpressionStmt.class, this.m.get("a").getClass());
        this.match("x; @a;", "x; x; x;");
        MatchTest.assertNull(this.m);
    }

    public final void testSingleOptionalHole() throws Exception {
        this.match("x; @a?;", "x;");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertNull((Object)this.m.get("a"));
        this.match("x; @a?;", "x; x;");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertEquals(ExpressionStmt.class, this.m.get("a").getClass());
        this.match("x; @a?;", "x; x; x");
        MatchTest.assertNull(this.m);
    }

    public final void testMultipleHole() throws Exception {
        this.match("x; @a*;", "x;");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertEquals(ParseTreeNodeContainer.class, this.m.get("a").getClass());
        MatchTest.assertEquals((int)0, (int)this.m.get("a").children().size());
        this.match("x; @a*;", "x; x;");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertEquals(ParseTreeNodeContainer.class, this.m.get("a").getClass());
        MatchTest.assertEquals((int)1, (int)this.m.get("a").children().size());
        MatchTest.assertEquals(ExpressionStmt.class, this.m.get("a").children().get(0).getClass());
        this.match("x; @a*;", "x; x; x;");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertEquals((int)2, (int)this.m.get("a").children().size());
    }

    public final void testMultipleNonemptyHole() throws Exception {
        this.match("x; @a+;", "x;");
        MatchTest.assertNull(this.m);
        this.match("x; @a+;", "x; x;");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertEquals(ParseTreeNodeContainer.class, this.m.get("a").getClass());
        MatchTest.assertEquals((int)1, (int)this.m.get("a").children().size());
        MatchTest.assertEquals(ExpressionStmt.class, this.m.get("a").children().get(0).getClass());
        this.match("x; @a+;", "x; x; x;");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertEquals((int)2, (int)this.m.get("a").children().size());
    }

    public final void testObjectConstructorHole() throws Exception {
        this.match("({ @k*: @v* });", "({ })");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertEquals(ParseTreeNodeContainer.class, this.m.get("k").getClass());
        MatchTest.assertEquals(ParseTreeNodeContainer.class, this.m.get("v").getClass());
        MatchTest.assertEquals((int)0, (int)this.m.get("k").children().size());
        MatchTest.assertEquals((int)0, (int)this.m.get("v").children().size());
        this.match("({ @k*: @v*, foo: @bar });", "({ foo: bar, boo: baz })");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertEquals(ParseTreeNodeContainer.class, this.m.get("k").getClass());
        MatchTest.assertEquals(ParseTreeNodeContainer.class, this.m.get("v").getClass());
        MatchTest.assertEquals((int)1, (int)this.m.get("k").children().size());
        MatchTest.assertEquals((int)1, (int)this.m.get("v").children().size());
        MatchTest.assertEquals(Reference.class, this.m.get("bar").getClass());
        MatchTest.assertEquals((String)"bar", (String)((Reference)this.m.get("bar")).getIdentifierName());
        this.match("({ @k* : @v* });", "({ a: 3, b: 4 })");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertEquals((int)2, (int)this.m.get("k").children().size());
        MatchTest.assertEquals((int)2, (int)this.m.get("v").children().size());
        MatchTest.assertEquals((String)"a", (String)((StringLiteral)this.m.get("k").children().get(0)).getUnquotedValue());
        MatchTest.assertEquals((String)"b", (String)((StringLiteral)this.m.get("k").children().get(1)).getUnquotedValue());
        MatchTest.assertEquals((int)3, (int)((IntegerLiteral)this.m.get("v").children().get(0)).getValue().intValue());
        MatchTest.assertEquals((int)4, (int)((IntegerLiteral)this.m.get("v").children().get(1)).getValue().intValue());
    }

    public final void testTrailingUnderscoreIdentifierHole() throws Exception {
        this.match("@a___ = 5;", "foo___ = 5;");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertEquals((String)"foo", (String)((Identifier)this.m.get("a")).getValue());
    }

    public final void testLiteral() throws Exception {
        this.match("x = @a;", "x = 3;");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertEquals((int)3, (int)((IntegerLiteral)this.m.get("a")).getValue().intValue());
        this.match("x = @a;", "y = 3;");
        MatchTest.assertNull(this.m);
    }

    public final void testReference() throws Exception {
        this.match("x = @a;", "x = y;");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertEquals((String)"y", (String)((Reference)this.m.get("a")).getIdentifierName());
        this.match("x = @a;", "y = y;");
        MatchTest.assertNull(this.m);
    }

    public final void testExpression() throws Exception {
        this.match("x = @a;", "x = pi() * (r * r);");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertEquals((Object)((Object)Operator.MULTIPLICATION), (Object)((Object)((Operation)this.m.get("a")).getOperator()));
    }

    public final void testFunctionIdentifier() throws Exception {
        this.match("function @a() { }", "function x() { }");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertEquals((String)"x", (String)((Identifier)this.m.get("a")).getValue());
    }

    public final void testFunctionWithBody() throws Exception {
        this.match("function @a() { x = 3; y = 4; }", "function x() { x = 3; y = 4; }");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertEquals((String)"x", (String)((Identifier)this.m.get("a")).getValue());
        this.match("function @a() { x = 3; y = 4; }", "function x() { x = 3; y = 3; }");
        MatchTest.assertNull(this.m);
    }

    public final void testFormalParams() throws Exception {
        this.match("function(@ps*) { @b*; }", "function(x, y) { x = 3; y = 4; }");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertEquals((int)2, (int)this.m.get("ps").children().size());
        MatchTest.assertEquals(FormalParam.class, this.m.get("ps").children().get(0).getClass());
        MatchTest.assertEquals((String)"x", (String)((FormalParam)this.m.get("ps").children().get(0)).getIdentifierName());
        MatchTest.assertEquals((int)2, (int)this.m.get("b").children().size());
        MatchTest.assertEquals(ExpressionStmt.class, this.m.get("b").children().get(0).getClass());
    }

    public final void testFunctionWithOptionalName() throws Exception {
        this.match("function @i?(@actuals*) { @body* }", "function x(a, b) { return; }");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertEquals((String)"x", (String)((Identifier)this.m.get("i")).getValue());
        this.match("function @i?(@actuals*) { @body* }", "function (a, b) { return; };");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertNull((Object)this.m.get("i"));
        MatchTest.assertEquals((String)"a", (String)((FormalParam)this.m.get("actuals").children().get(0)).getIdentifierName());
        MatchTest.assertEquals((String)"b", (String)((FormalParam)this.m.get("actuals").children().get(1)).getIdentifierName());
        MatchTest.assertEquals(ReturnStmt.class, this.m.get("body").children().get(0).getClass());
        this.match("function @i?(@actuals*) { @body* }", "function f(a, b) { return; }");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertEquals((String)"f", (String)((Identifier)this.m.get("i")).getValue());
        MatchTest.assertEquals((String)"a", (String)((FormalParam)this.m.get("actuals").children().get(0)).getIdentifierName());
        MatchTest.assertEquals((String)"b", (String)((FormalParam)this.m.get("actuals").children().get(1)).getIdentifierName());
        MatchTest.assertEquals(ReturnStmt.class, this.m.get("body").children().get(0).getClass());
    }

    public final void testDotAccessorReference() throws Exception {
        this.match("@a.@b;", "foo.bar;");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertEquals((String)"foo", (String)((Reference)this.m.get("a")).getIdentifierName());
        MatchTest.assertEquals((String)"bar", (String)((Reference)this.m.get("b")).getIdentifierName());
    }

    public final void testBracketAccessorReference() throws Exception {
        this.match("@a[@b];", "foo[bar];");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertEquals((String)"foo", (String)((Reference)this.m.get("a")).getIdentifierName());
        MatchTest.assertEquals((String)"bar", (String)((Reference)this.m.get("b")).getIdentifierName());
    }

    public final void testBracketAccessorStringLiteral() throws Exception {
        this.match("@a[@b];", "foo[\"bar\"];");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertEquals((String)"foo", (String)((Reference)this.m.get("a")).getIdentifierName());
        MatchTest.assertEquals((String)"bar", (String)((StringLiteral)this.m.get("b")).getUnquotedValue());
    }

    public final void testBracketAccessorIntegerLiteral() throws Exception {
        this.match("@a[@b];", "foo[3];");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertEquals((String)"foo", (String)((Reference)this.m.get("a")).getIdentifierName());
        MatchTest.assertEquals((int)3, (int)((IntegerLiteral)this.m.get("b")).getValue().intValue());
    }

    public final void testNew() throws Exception {
        this.match("new @a(@b*);", "new foo(x, y, z);");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertEquals((String)"foo", (String)((Reference)this.m.get("a")).getIdentifierName());
        MatchTest.assertEquals(Reference.class, this.m.get("a").getClass());
        MatchTest.assertEquals((int)3, (int)this.m.get("b").children().size());
        MatchTest.assertEquals(Reference.class, this.m.get("b").children().get(0).getClass());
    }

    public final void testFunctionWithNulIdentifier() throws Exception {
        this.match("function @f() {}", "var foo = function() {};");
        MatchTest.assertNull(this.m);
        this.match("function() {}", "var foo = function() {};");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertEquals((int)0, (int)this.m.size());
        this.match("function @f() {}", "function foo() {}");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertEquals((String)"foo", (String)((Identifier)this.m.get("f")).getName());
    }

    public final void testDirectivePrologueInFunctionBodies() throws Exception {
        this.match("function () { 'use strict'; @stmts* }", "function () { return 4; };");
        MatchTest.assertNull(this.m);
        this.match("function () { 'use strict'; @stmts* }", "function () { 'use strict'; return 4; };");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertEquals(ReturnStmt.class, this.m.get("stmts").children().get(0).getClass());
        this.match("function f() { 'use strict'; @stmts* }", "function f() { return 4; }");
        MatchTest.assertNull(this.m);
        this.match("function f() { 'use strict'; @stmts* }", "function f() { 'use strict'; return 4; }");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertEquals(ReturnStmt.class, this.m.get("stmts").children().get(0).getClass());
        this.match("function f() { 'use strict'; @stmts* }", "(function f() { return 4; });");
        MatchTest.assertNull(this.m);
        this.match("function f() { 'use strict'; @stmts* }", "(function f() { 'use strict'; return 4; });");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertEquals(ReturnStmt.class, this.m.get("stmts").children().get(0).getClass());
        this.match("function f() { 'use strict'; 'use cajita'; @stmts* }", "(function f() { 'use strict'; return 4; });");
        MatchTest.assertNull(this.m);
        this.match("function f() { 'use strict'; @stmts* }", "(function f() { 'use strict'; 'use cajita'; return 4; });");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertEquals(ReturnStmt.class, this.m.get("stmts").children().get(0).getClass());
    }

    public final void testStringLiteralQuasis() throws Exception {
        this.match("o['@p'] = q;", "o['P'] = q;");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertEquals((String)"P", (String)((Identifier)this.m.get("p")).getName());
        this.match("function @name() { @body* }", "function foo() {}");
        MatchTest.assertNotNull(this.m);
        MatchTest.assertEquals((String)"foo", (String)((Identifier)this.m.get("name")).getName());
        MatchTest.assertEquals((String)MatchTest.render(this.jsExpr(this.fromString("fakeGlobals['foo'] = function foo() {}"))), (String)MatchTest.render(QuasiBuilder.substV("fakeGlobals['@name'] = function @name() { @body* }", "name", this.m.get("name"), "body", this.m.get("body"))));
    }

    public final void testStringEquivalence() throws Exception {
        MatchTest.assertTrue((boolean)QuasiBuilder.match("('foo')", this.jsExpr(this.fromString("'foo'"))));
        MatchTest.assertTrue((boolean)QuasiBuilder.match("('bar')", this.jsExpr(this.fromString("'bar'"))));
        MatchTest.assertTrue((boolean)QuasiBuilder.match("('foo')", this.jsExpr(this.fromString("'f\\oo'"))));
        MatchTest.assertTrue((boolean)QuasiBuilder.match("('foo')", this.jsExpr(this.fromString("\"foo\""))));
        MatchTest.assertTrue((boolean)QuasiBuilder.match("('f\\oo')", this.jsExpr(this.fromString("'foo'"))));
        MatchTest.assertTrue((boolean)QuasiBuilder.match("('f\\oo')", this.jsExpr(this.fromString("'f\\oo'"))));
        MatchTest.assertFalse((boolean)QuasiBuilder.match("('bar')", this.jsExpr(this.fromString("'foo'"))));
    }

    private void match(String pattern, String source) throws Exception {
        QuasiNode qn = QuasiBuilder.parseQuasiNode(new InputSource(URI.create("built-in:///js-quasi-literals")), pattern);
        System.out.println(qn.render());
        this.m = null;
        this.findMatch(qn, this.quasi(this.fromString(source)));
        if (this.m != null) {
            System.out.println(this.m);
        }
    }

    private void findMatch(QuasiNode qn, ParseTreeNode n) {
        this.m = qn.match(n);
        if (this.m != null) {
            return;
        }
        for (ParseTreeNode parseTreeNode : n.children()) {
            this.findMatch(qn, parseTreeNode);
            if (this.m == null) continue;
            return;
        }
    }
}

