/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.ObjProperty;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.quasiliteral.MultiPropertyQuasi;
import com.google.caja.parser.quasiliteral.QuasiNode;
import com.google.caja.util.Lists;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ObjectCtorQuasiNode
extends QuasiNode {
    ObjectCtorQuasiNode(QuasiNode ... propertyQuasis) {
        super(propertyQuasis);
    }

    @Override
    protected boolean consumeSpecimens(List<ParseTreeNode> specimens, Map<String, ParseTreeNode> bindings) {
        if (specimens.isEmpty()) {
            return false;
        }
        ParseTreeNode specimen = specimens.get(0);
        if (!(specimen instanceof ObjectConstructor)) {
            return false;
        }
        ObjectConstructor obj = (ObjectConstructor)specimen;
        LinkedList<ParseTreeNode> parts = Lists.newLinkedList(obj.children());
        MultiPropertyQuasi hole = null;
        for (QuasiNode q : this.getChildren()) {
            if (q instanceof MultiPropertyQuasi) {
                hole = (MultiPropertyQuasi)q;
                continue;
            }
            if (q.consumeSpecimens(parts, bindings)) continue;
            return false;
        }
        if (hole != null && !hole.consumeSpecimens(parts, bindings)) {
            return false;
        }
        if (!parts.isEmpty()) {
            return false;
        }
        specimens.remove(0);
        return true;
    }

    @Override
    protected boolean createSubstitutes(List<ParseTreeNode> substitutes, Map<String, ParseTreeNode> bindings) {
        List<ParseTreeNode> props = Lists.newArrayList();
        for (QuasiNode q : this.getChildren()) {
            if (q.createSubstitutes(props, bindings)) continue;
            return false;
        }
        ObjProperty[] propArr = new ObjProperty[props.size()];
        props.toArray(propArr);
        substitutes.add(new ObjectConstructor(FilePosition.UNKNOWN, Arrays.asList(propArr)));
        return true;
    }
}

