/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.render;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.JsTokenType;
import com.google.caja.lexer.Keyword;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.IntegerLiteral;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.Parser;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsPrettyPrinter;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.MoreAsserts;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsPrettyPrinterTest
extends CajaTestCase {
    private static final JsTokenType[] TYPES = JsTokenType.values();
    private static final Operator[] OPERATORS = Operator.values();
    private static final Keyword[] KEYWORDS = Keyword.values();
    private static final String WORD_CHARS = "_$ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";

    public final void testEmptyBlock() throws Exception {
        this.assertRendered("{ {} }", "{}");
    }

    public final void testAdjacentBlocks() throws Exception {
        this.assertRendered("{ {}\n  {} }", "{}{}");
    }

    public final void testSimpleStatement() throws Exception {
        this.assertRendered("{ foo(); }", "foo();");
    }

    public final void testLongLines() throws Exception {
        this.assertRendered("{\n  cdefgh10abcdefgh20abcdefgh30abcdefgh40abcdefgh50abcdefgh60abcdefgh70abcd();\n}", "  cdefgh10abcdefgh20abcdefgh30abcdefgh40abcdefgh50abcdefgh60abcdefgh70abcd();");
        this.assertRendered("{\n  cdefgh10abcdefgh20abcdefgh30abcdefgh40abcdefgh50abcdefgh60abcdefgh70abcde();\n}", "  cdefgh10abcdefgh20abcdefgh30abcdefgh40abcdefgh50abcdefgh60abcdefgh70abcde();");
        this.assertRendered("{\n  cdefgh10abcdefgh20abcdefgh30abcdefgh40abcdefgh50abcdefgh60abcdefgh70abcdefgh()\n    ;\n}", "  cdefgh10abcdefgh20abcdefgh30abcdefgh40abcdefgh50abcdefgh60abcdefgh70abcdefgh();");
    }

    public final void testSemisInsideParents() throws Exception {
        this.assertRendered("{\n  for (var i = 0, n = a.length; i < n; ++i) {\n    bar(a[ i ]);\n  }\n}", "for (var i = 0, n = a.length; i < n; ++i) {  bar(a[ i ]);}");
    }

    public final void testObjectConstructor() throws Exception {
        this.assertRendered("{\n  foo({\n      'x': 1,\n      'y': bar({ 'w': 4 }),\n      'z': 3\n    });\n}", "foo({ x: 1, y: bar({ w: 4 }), z: 3 });");
    }

    public final void testMultipleStatements() throws Exception {
        this.assertRendered("{\n  (function (a, b, c) {\n     foo(a);\n     bar(b);\n     return c;\n   })(1, 2, 3);\n}", "(function (a, b, c) { foo(a); bar(b); return (c); })(1, 2, 3);");
    }

    public final void testBreakBeforeWhile() throws Exception {
        this.assertRendered("{\n  do {\n    foo(bar());\n  } while (1);\n}", "do { foo(bar()); } while(1);");
        this.assertRendered("{\n  {\n    foo(bar());\n  }\n  while (1);\n}", "{ foo(bar()); } while(1);");
    }

    public final void testMarkupEndStructures() throws Exception {
        this.assertRendered("{\n  (i--) > j, k < /script>/, [ [ 0 ] ] > 0;\n}", "i-->j, k</script>/, [[0]]>0;");
    }

    public final void testJSON() throws Exception {
        this.assertRendered("{\n  ({\n     'a': [ 1, 2, 3 ],\n     'b': {\n       'c': [{}],\n       'd': [{\n           'e': null,\n           'f': 'foo'\n         }, null ]\n     }\n   });\n}", "({ a: [1,2,3], b: { c: [{}], d: [{ e: null, f: 'foo' }, null] } });");
    }

    public final void testConditional() throws Exception {
        this.assertRendered("{\n  if (c1) { foo(); } else if (c2) bar();\n  else baz();\n}", "if (c1) { foo(); } else if (c2) bar(); else baz();");
    }

    public final void testNumberPropertyAccess() throws Exception {
        this.assertRendered("{\n  (3).toString();\n}", "(3).toString();");
    }

    public final void testComments() throws Exception {
        this.assertLexed("var x = foo; /* end of line */\n/** Own line */\nfunction Bar() {}\n/* Beginning */\nvar baz;\na+// Line comment\n  b;", "var x = foo;  /* end of line */\n/** Own line */\nfunction Bar() {}\n/* Beginning */ var baz;\na +  // Line comment\nb;");
    }

    public final void testDivisionByRegex() throws Exception {
        this.assertLexed("3/ /foo/;", "3 / /foo/;");
    }

    public final void testNegatedNegativeNumericConstants() {
        this.assertRendered("- (-3)", Operation.create(FilePosition.UNKNOWN, Operator.NEGATION, new IntegerLiteral(FilePosition.UNKNOWN, -3L)));
    }

    public final void testRetokenization() throws Exception {
        long seed = Long.parseLong(System.getProperty("junit.seed", "" + System.currentTimeMillis()));
        Random rnd = new Random(seed);
        try {
            int i = 1000;
            while (--i >= 0) {
                List<String> randomTokens = this.generateRandomTokens(rnd);
                StringBuilder sb = new StringBuilder();
                JsPrettyPrinter pp = new JsPrettyPrinter(new Concatenator(sb));
                for (String token : randomTokens) {
                    pp.consume(token);
                }
                pp.noMoreTokens();
                ArrayList<String> actualTokens = new ArrayList<String>();
                try {
                    JsLexer lex = new JsLexer(this.fromString(sb.toString()));
                    while (lex.hasNext()) {
                        actualTokens.add(JsPrettyPrinterTest.simplifyComments(lex.next().text));
                    }
                }
                catch (ParseException ex) {
                    for (String tok : randomTokens) {
                        System.err.println(StringLiteral.toQuotedValue(tok));
                    }
                    System.err.println("<<<" + sb + ">>>");
                    throw ex;
                }
                ArrayList<String> simplifiedRandomTokens = new ArrayList<String>();
                for (String randomToken : randomTokens) {
                    simplifiedRandomTokens.add(JsPrettyPrinterTest.simplifyComments(randomToken));
                }
                MoreAsserts.assertListsEqual(simplifiedRandomTokens, actualTokens);
            }
        }
        catch (Exception e) {
            System.err.println("Using seed " + seed);
            throw e;
        }
    }

    private static String simplifyComments(String token) {
        if (token.startsWith("//")) {
            token = "/*" + token.substring(2) + "*/";
        }
        if (!token.startsWith("/*")) {
            return token;
        }
        StringBuilder sb = new StringBuilder(token);
        int i = sb.length() - 2;
        while (--i >= 2) {
            if (!JsLexer.isJsLineSeparator(sb.charAt(i))) continue;
            sb.setCharAt(i, ' ');
        }
        int close = -1;
        while ((close = sb.indexOf("*/", close + 1)) >= 0) {
            sb.setCharAt(close + 1, ' ');
        }
        return sb.toString();
    }

    public final void testIndentationAfterParens1() {
        this.assertTokens("longObjectInstance.reallyLongMethodName(a, b, c, d);", "longObjectInstance", ".", "reallyLongMethodName", "(", "a", ",", "b", ",", "c", ",", "d", ")", ";");
    }

    public final void testIndentationAfterParens2() {
        this.assertTokens("longObjectInstance.reallyLongMethodName(a, b, c,\n  d);", "longObjectInstance", ".", "reallyLongMethodName", "(", "a", ",", "b", ",", "c", ",", "\n", "d", ")", ";");
    }

    public final void testIndentationAfterParens3() {
        this.assertTokens("longObjectInstance.reallyLongMethodName(\n  a, b, c, d);", "longObjectInstance", ".", "reallyLongMethodName", "(", "\n", "a", ",", "b", ",", "c", ",", "d", ")", ";");
    }

    public final void testIndentationAfterParens4() {
        this.assertTokens("var x = ({\n    'fooBar': [\n      0, 1, 2, ]\n  });", "var", "x", "=", "(", "{", "'fooBar'", ":", "[", "\n", "0", ",", "1", ",", "2", ",", "]", "}", ")", ";");
    }

    public final void testCommentsInRestrictedProductions1() {
        this.assertTokens("return /* */ 4;", "return", "/*\n*/", "4", ";");
    }

    public final void testCommentsInRestrictedProductions2() {
        this.assertTokens("return /**/ 4;", "return", "//", "4", ";");
    }

    private List<String> generateRandomTokens(Random rnd) {
        ArrayList<String> tokens = new ArrayList<String>();
        int i = 10;
        block15: while (--i >= 0) {
            String tok;
            block0 : switch (TYPES[rnd.nextInt(TYPES.length)]) {
                case COMMENT: {
                    if (rnd.nextBoolean()) {
                        String s = "//" + JsPrettyPrinterTest.randomString(rnd).replace('\r', '\ufffd').replace('\n', '\ufffd').replace('\u2028', '\ufffd').replace('\u2029', '\ufffd');
                        if (s.endsWith("\\")) {
                            s = s + " ";
                        }
                        tok = s;
                        break;
                    }
                    tok = "/*" + JsPrettyPrinterTest.randomString(rnd).replace('*', '.') + "*/";
                    break;
                }
                case STRING: {
                    tok = StringLiteral.toQuotedValue(JsPrettyPrinterTest.randomString(rnd));
                    break;
                }
                case REGEXP: {
                    tokens.add("=");
                    StringBuilder out = new StringBuilder();
                    out.append('/');
                    Escaping.normalizeRegex((CharSequence)JsPrettyPrinterTest.randomString(rnd), false, false, out);
                    out.append('/');
                    if (rnd.nextBoolean()) {
                        out.append('g');
                    }
                    if (rnd.nextBoolean()) {
                        out.append('m');
                    }
                    if (rnd.nextBoolean()) {
                        out.append('i');
                    }
                    tok = out.toString();
                    break;
                }
                case PUNCTUATION: {
                    Operator op = OPERATORS[rnd.nextInt(OPERATORS.length)];
                    tok = op.getClosingSymbol() != null ? (rnd.nextBoolean() ? op.getOpeningSymbol() : op.getClosingSymbol()) : op.getSymbol();
                    if (!tok.startsWith("/")) break;
                    tokens.add("3");
                    break;
                }
                case WORD: {
                    tok = JsPrettyPrinterTest.randomWord(rnd);
                    break;
                }
                case KEYWORD: {
                    tok = KEYWORDS[rnd.nextInt(KEYWORDS.length)].toString();
                    break;
                }
                case INTEGER: {
                    int j = rnd.nextInt(Integer.MAX_VALUE);
                    switch (rnd.nextInt(3)) {
                        case 0: {
                            tok = Integer.toString(j, 10);
                            break block0;
                        }
                        case 1: {
                            tok = "0" + Integer.toString(Math.abs(j), 8);
                            break block0;
                        }
                    }
                    tok = "0x" + Long.toString(Math.abs((long)j), 16);
                    break;
                }
                case FLOAT: {
                    tok = "" + Math.abs(rnd.nextFloat());
                    break;
                }
                case LINE_CONTINUATION: {
                    continue block15;
                }
                default: {
                    throw new SomethingWidgyHappenedError();
                }
            }
            tokens.add(tok);
        }
        return tokens;
    }

    private static String randomWord(Random rnd) {
        int len = rnd.nextInt(100) + 1;
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append(WORD_CHARS.charAt(rnd.nextInt(WORD_CHARS.length())));
        }
        if (Character.isDigit(sb.charAt(0))) {
            sb.insert(0, '_');
        }
        return sb.toString();
    }

    private static String randomString(Random rnd) {
        int minCp = 0;
        int maxCp = 0;
        if (rnd.nextBoolean()) {
            minCp = 32;
            maxCp = 127;
        } else {
            minCp = 0;
            maxCp = 53248;
        }
        int len = rnd.nextInt(100) + 1;
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.appendCodePoint(rnd.nextInt(maxCp - minCp) + minCp);
        }
        return sb.toString();
    }

    private void assertRendered(String golden, String input) throws Exception {
        JsLexer lex = new JsLexer(this.fromString(input));
        JsTokenQueue tq = new JsTokenQueue(lex, this.is);
        Block node = new Parser(tq, this.mq).parse();
        tq.expectEmpty();
        this.assertRendered(golden, node);
    }

    private void assertRendered(String golden, ParseTreeNode node) {
        StringBuilder out = new StringBuilder();
        JsPrettyPrinter pp = new JsPrettyPrinter(new Concatenator(out));
        node.render(new RenderContext(pp));
        pp.noMoreTokens();
        JsPrettyPrinterTest.assertEquals((String)golden, (String)out.toString());
    }

    private void assertLexed(String golden, String input) throws Exception {
        StringBuilder out = new StringBuilder();
        JsPrettyPrinter pp = new JsPrettyPrinter(new Concatenator(out));
        JsLexer lex = new JsLexer(this.fromString(input));
        while (lex.hasNext()) {
            Token<JsTokenType> t = lex.next();
            pp.mark(t.pos);
            pp.consume(t.text);
        }
        pp.noMoreTokens();
        JsPrettyPrinterTest.assertEquals((String)golden, (String)out.toString());
    }

    private void assertTokens(String golden, String ... input) {
        StringBuilder out = new StringBuilder();
        JsPrettyPrinter pp = new JsPrettyPrinter(new Concatenator(out));
        for (String token : input) {
            pp.consume(token);
        }
        pp.noMoreTokens();
        JsPrettyPrinterTest.assertEquals((String)golden, (String)out.toString());
    }
}

