/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.reporting;

import com.google.caja.reporting.AbstractMessageQueue;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EchoingMessageQueue
extends AbstractMessageQueue {
    private final List<Message> messages;
    private final MessageContext mc;
    private boolean dumpStack;

    public EchoingMessageQueue(PrintWriter out, MessageContext context) {
        this(out, context, true);
    }

    public EchoingMessageQueue(final PrintWriter out, MessageContext context, boolean dumpStack) {
        this.mc = context;
        this.messages = new AbstractList<Message>(){
            List<Message> backing = new ArrayList<Message>();

            @Override
            public void add(int index, Message element) {
                this.backing.add(index, element);
                try {
                    out.append(element.getMessageLevel().name()).append(':');
                    element.format(EchoingMessageQueue.this.mc, out);
                    out.append('\n');
                    if (EchoingMessageQueue.this.dumpStack && element.getMessageLevel().compareTo(MessageLevel.LINT) >= 0) {
                        new Exception().printStackTrace(out);
                    }
                    out.flush();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }

            @Override
            public Message get(int index) {
                return this.backing.get(index);
            }

            @Override
            public Message remove(int index) {
                return this.backing.remove(index);
            }

            @Override
            public int size() {
                return this.backing.size();
            }
        };
        this.dumpStack = dumpStack;
    }

    @Override
    public List<Message> getMessages() {
        return this.messages;
    }

    public MessageContext getMessageContext() {
        return this.mc;
    }

    public void setDumpStack(boolean dumpStack) {
        this.dumpStack = dumpStack;
    }
}

