/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.service;

import com.google.caja.service.ContentTypeCheck;
import com.google.caja.service.LooseContentTypeCheck;
import com.google.caja.service.StrictContentTypeCheck;
import junit.framework.TestCase;

public class ContentTypeCheckTest
extends TestCase {
    public final void testStrictContentTypeCheck() {
        StrictContentTypeCheck ctc = new StrictContentTypeCheck();
        ContentTypeCheckTest.assertFalse((boolean)((ContentTypeCheck)ctc).check("image/*", ""));
        ContentTypeCheckTest.assertFalse((boolean)((ContentTypeCheck)ctc).check("image/*", "bogus-nonsense"));
        ContentTypeCheckTest.assertFalse((boolean)((ContentTypeCheck)ctc).check("image/*", "; hellow=world"));
        ContentTypeCheckTest.assertTrue((boolean)((ContentTypeCheck)ctc).check("text/plain", "text/plain"));
        ContentTypeCheckTest.assertFalse((boolean)((ContentTypeCheck)ctc).check("text/plain", "text/javascript"));
        ContentTypeCheckTest.assertTrue((boolean)((ContentTypeCheck)ctc).check("text/*", "text/plain"));
        ContentTypeCheckTest.assertTrue((boolean)((ContentTypeCheck)ctc).check("text/*", "text/javascript"));
        ContentTypeCheckTest.assertTrue((boolean)((ContentTypeCheck)ctc).check("text/javascript", "text/javascript"));
        ContentTypeCheckTest.assertTrue((boolean)((ContentTypeCheck)ctc).check("text/javascript", "text/javascript;charset=UTF-8"));
        ContentTypeCheckTest.assertTrue((boolean)((ContentTypeCheck)ctc).check("text/javascript", "text/javascript; charset=UTF-8"));
        ContentTypeCheckTest.assertTrue((boolean)((ContentTypeCheck)ctc).check("text/javascript", "text/javascript; e4x=1"));
        ContentTypeCheckTest.assertFalse((boolean)((ContentTypeCheck)ctc).check("text/javascript", "application/x-javascript"));
        ContentTypeCheckTest.assertFalse((boolean)((ContentTypeCheck)ctc).check("text/vbscript", "text/javascript"));
        ContentTypeCheckTest.assertTrue((boolean)((ContentTypeCheck)ctc).check("*/*", "text/html"));
        ContentTypeCheckTest.assertTrue((boolean)((ContentTypeCheck)ctc).check("*/*", "text/javascript"));
        ContentTypeCheckTest.assertTrue((boolean)((ContentTypeCheck)ctc).check("*/*", "image/jpg"));
        ContentTypeCheckTest.assertTrue((boolean)((ContentTypeCheck)ctc).check("image/*", "image/jpg"));
    }

    public final void testLooseContentTypeCheck() {
        LooseContentTypeCheck ctc = new LooseContentTypeCheck();
        ContentTypeCheckTest.assertFalse((boolean)((ContentTypeCheck)ctc).check("image/*", ""));
        ContentTypeCheckTest.assertFalse((boolean)((ContentTypeCheck)ctc).check("image/*", "bogus-nonsense"));
        ContentTypeCheckTest.assertFalse((boolean)((ContentTypeCheck)ctc).check("image/*", "; hellow=world"));
        ContentTypeCheckTest.assertTrue((boolean)((ContentTypeCheck)ctc).check("text/plain", "text/plain"));
        ContentTypeCheckTest.assertFalse((boolean)((ContentTypeCheck)ctc).check("text/plain", "text/javascript"));
        ContentTypeCheckTest.assertTrue((boolean)((ContentTypeCheck)ctc).check("text/*", "text/plain"));
        ContentTypeCheckTest.assertTrue((boolean)((ContentTypeCheck)ctc).check("text/*", "text/javascript"));
        ContentTypeCheckTest.assertTrue((boolean)((ContentTypeCheck)ctc).check("text/javascript", "text/javascript"));
        ContentTypeCheckTest.assertTrue((boolean)((ContentTypeCheck)ctc).check("text/javascript", "text/javascript;charset=UTF-8"));
        ContentTypeCheckTest.assertTrue((boolean)((ContentTypeCheck)ctc).check("text/javascript", "text/javascript; charset=UTF-8"));
        ContentTypeCheckTest.assertTrue((boolean)((ContentTypeCheck)ctc).check("text/javascript", "text/javascript; e4x=1"));
        ContentTypeCheckTest.assertTrue((boolean)((ContentTypeCheck)ctc).check("text/javascript", "application/x-javascript"));
        ContentTypeCheckTest.assertFalse((boolean)((ContentTypeCheck)ctc).check("text/vbscript", "text/javascript"));
        ContentTypeCheckTest.assertTrue((boolean)((ContentTypeCheck)ctc).check("*/*", "text/html"));
        ContentTypeCheckTest.assertTrue((boolean)((ContentTypeCheck)ctc).check("*/*", "text/javascript"));
        ContentTypeCheckTest.assertTrue((boolean)((ContentTypeCheck)ctc).check("*/*", "image/jpg"));
        ContentTypeCheckTest.assertTrue((boolean)((ContentTypeCheck)ctc).check("image/*", "image/jpg"));
    }
}

