/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.util;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Directive;
import com.google.caja.parser.js.DirectivePrologue;
import com.google.caja.parser.js.Parser;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.UncajoledModule;
import com.google.caja.parser.quasiliteral.CajitaRewriter;
import com.google.caja.parser.quasiliteral.DefaultValijaRewriter;
import com.google.caja.reporting.EchoingMessageQueue;
import com.google.caja.reporting.MarkupRenderMode;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.RenderContext;
import com.google.caja.reporting.TestBuildInfo;
import com.google.caja.util.Executor;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import com.google.caja.util.Pair;
import com.google.caja.util.RhinoExecutor;
import com.google.caja.util.TestUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class RhinoTestBed {
    private static final String HTML_NS = "http://www.w3.org/1999/xhtml";

    public static Object runJs(Executor.Input ... inputs) {
        try {
            Map<String, Object> actuals = Maps.newHashMap();
            actuals.put("stderr", System.err);
            actuals.put("_junit_", new JunitSandBoxSafe());
            RhinoExecutor exec = new RhinoExecutor(inputs);
            return exec.run(actuals, Object.class);
        }
        catch (Executor.AbnormalExitException ex) {
            Throwable th = ex.getCause();
            if (th instanceof Error) {
                throw (Error)th;
            }
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            throw new SomethingWidgyHappenedError(ex);
        }
    }

    public static void runJsUnittestFromHtml(Element html) throws IOException, ParseException {
        TestUtil.enableContentUrls();
        List<Executor.Input> inputs = Lists.newArrayList();
        inputs.add(new Executor.Input(RhinoTestBed.class, "../plugin/console-stubs.js"));
        inputs.add(new Executor.Input(RhinoTestBed.class, "/js/jqueryjs/runtest/env.js"));
        int injectHtmlIndex = inputs.size();
        ArrayList<Pair<String, InputSource>> scriptContent = new ArrayList<Pair<String, InputSource>>();
        MessageContext mc = new MessageContext();
        EchoingMessageQueue mq = new EchoingMessageQueue(new PrintWriter(System.err), mc);
        ArrayList<Element> scripts = new ArrayList<Element>();
        for (Element element : Nodes.nodeListIterable(html.getElementsByTagNameNS(HTML_NS, "script"), Element.class)) {
            scripts.add(element);
        }
        for (Element element : scripts) {
            CharProducer scriptBody;
            Attr src = element.getAttributeNodeNS(HTML_NS, "src");
            if (src != null) {
                InputSource resource;
                String resourcePath = src.getNodeValue();
                if (resourcePath.startsWith("/")) {
                    try {
                        resource = new InputSource(RhinoTestBed.class.getResource(resourcePath).toURI());
                    }
                    catch (URISyntaxException ex) {
                        throw new SomethingWidgyHappenedError("java.net.URL is not a valid java.net.URI", (Throwable)ex);
                    }
                } else {
                    InputSource baseUri = Nodes.getFilePositionFor(html).source();
                    resource = new InputSource(baseUri.getUri().resolve(resourcePath));
                }
                scriptBody = RhinoTestBed.loadResource(resource);
            } else {
                scriptBody = RhinoTestBed.textContentOf(element);
            }
            Block js = RhinoTestBed.parseJavascript(scriptBody, mq);
            String scriptText = RhinoTestBed.shouldCajoleBlock(js) ? RhinoTestBed.render(RhinoTestBed.cajole(js, mq)) : RhinoTestBed.prefixWithBlankLines(scriptBody.toString(0, scriptBody.getLimit()), Nodes.getFilePositionFor(element).startLineNo() - 1);
            scriptContent.add(Pair.pair(scriptText, js.getFilePosition().source()));
            mc.addInputSource(js.getFilePosition().source());
            element.getParentNode().removeChild(element);
        }
        for (Pair pair : scriptContent) {
            inputs.add(new Executor.Input((String)pair.a, mc.abbreviate((InputSource)pair.b)));
        }
        String domJs = "window.location = " + StringLiteral.toQuotedValue(TestUtil.makeContentUrl(Nodes.render(html))) + ";";
        String string = Nodes.getFilePositionFor(html).source().toString();
        inputs.add(injectHtmlIndex, new Executor.Input(domJs, string));
        inputs.add(new Executor.Input("(function () {\n   var onload = document.body.getAttribute('onload');\n   onload && eval(onload);\n })();", string));
        RhinoTestBed.runJs(inputs.toArray(new Executor.Input[inputs.size()]));
    }

    private static ParseTreeNode cajole(Block program, MessageQueue mq) {
        DefaultValijaRewriter vrw = new DefaultValijaRewriter(mq, false);
        CajitaRewriter crw = new CajitaRewriter(new TestBuildInfo(), mq, false);
        return crw.expand(vrw.expand(new UncajoledModule(program)));
    }

    private static String render(ParseTreeNode n) {
        StringBuilder sb = new StringBuilder();
        TokenConsumer tc = n.makeRenderer(sb, null);
        n.render(new RenderContext(tc).withMarkupRenderMode(MarkupRenderMode.XML));
        tc.noMoreTokens();
        return sb.toString();
    }

    private static boolean shouldCajoleBlock(Block block) {
        if (block.children().isEmpty()) {
            return false;
        }
        Statement first = block.children().get(0);
        if (!(first instanceof DirectivePrologue)) {
            return false;
        }
        DirectivePrologue prologue = (DirectivePrologue)first;
        return prologue.getDirectives().contains(Directive.RecognizedValue.USE_CAJITA.getDirectiveString()) || prologue.getDirectives().contains("use valija");
    }

    private static Block parseJavascript(CharProducer cp, MessageQueue mq) throws ParseException {
        JsLexer lexer = new JsLexer(cp, false);
        Parser p = new Parser(new JsTokenQueue(lexer, cp.getSourceBreaks(0).source()), mq, false);
        return p.parse();
    }

    private static CharProducer loadResource(InputSource resource) throws IOException {
        File f = new File(resource.getUri());
        return CharProducer.Factory.create((Reader)new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"), resource);
    }

    private static String prefixWithBlankLines(String s, int n) {
        if (n <= 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() + n);
        while (--n >= 0) {
            sb.append('\n');
        }
        return sb.append(s).toString();
    }

    private static CharProducer textContentOf(Element script) {
        ArrayList<CharProducer> parts = new ArrayList<CharProducer>();
        for (Node node : Nodes.childrenOf(script)) {
            FilePosition childPos = Nodes.getFilePositionFor(node);
            switch (node.getNodeType()) {
                case 3: {
                    String rawText = Nodes.getRawText((Text)node);
                    String decodedText = node.getNodeValue();
                    CharProducer cp = null;
                    if (rawText != null && !String.valueOf((cp = CharProducer.Factory.fromHtmlAttribute(CharProducer.Factory.create(new StringReader(rawText), childPos))).getBuffer(), cp.getOffset(), cp.getLength()).equals(decodedText)) {
                        cp = null;
                    }
                    if (cp == null) {
                        cp = CharProducer.Factory.create(new StringReader(node.getNodeValue()), childPos);
                    }
                    parts.add(cp);
                    break;
                }
                case 4: {
                    parts.add(CharProducer.Factory.create(new StringReader("         " + node.getNodeValue()), childPos));
                    break;
                }
            }
        }
        return CharProducer.Factory.chain(parts.toArray(new CharProducer[0]));
    }

    private RhinoTestBed() {
    }

    public static final class JunitSandBoxSafe {
        public void fail(Object message) {
            Assert.fail((String)("" + message));
        }

        public void fail() {
            Assert.fail();
        }

        public boolean isAssertionFailedError(Object o) {
            return o instanceof AssertionFailedError;
        }
    }
}

