/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.validator.html.scan;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.Date;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xml.serialize.HTMLSerializer;
import org.apache.xml.serialize.OutputFormat;
import org.cyberneko.html.parsers.SAXParser;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.ScanException;
import org.owasp.validator.html.scan.AbstractAntiSamyScanner;
import org.owasp.validator.html.scan.MagicSAXFilter;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class AntiSamySAXScanner
extends AbstractAntiSamyScanner {
    public AntiSamySAXScanner(Policy policy) {
        super(policy);
    }

    public CleanResults getResults() {
        return null;
    }

    public CleanResults scan(String html, String inputEncoding, String outputEncoding) throws ScanException {
        if (html == null) {
            throw new ScanException(new NullPointerException("Null input"));
        }
        int maxInputSize = this.policy.getMaxInputSize();
        if (html.length() > maxInputSize) {
            this.addError("error.size.toolarge", new Object[]{new Integer(html.length()), new Integer(maxInputSize)});
            throw new ScanException(this.errorMessages.get(0).toString());
        }
        try {
            boolean formatOutput = "true".equals(this.policy.getDirective("formatOutput"));
            boolean useXhtml = "true".equals(this.policy.getDirective("useXHTML"));
            boolean omitXml = "true".equals(this.policy.getDirective("omitXmlDeclaration"));
            SAXParser parser = new SAXParser();
            parser.setFeature("http://xml.org/sax/features/namespaces", false);
            parser.setFeature("http://cyberneko.org/html/features/balance-tags/document-fragment", true);
            parser.setFeature("http://cyberneko.org/html/features/scanner/cdata-sections", true);
            parser.setFeature("http://apache.org/xml/features/scanner/notify-char-refs", true);
            parser.setFeature("http://apache.org/xml/features/scanner/notify-builtin-refs", true);
            StringWriter out = new StringWriter();
            MagicSAXFilter sanitizingFilter = new MagicSAXFilter(this.policy, this.messages);
            XMLDocumentFilter[] filters = new XMLDocumentFilter[]{sanitizingFilter};
            parser.setProperty("http://cyberneko.org/html/properties/filters", (Object)filters);
            parser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"lower");
            Date start = new Date();
            SAXSource source = new SAXSource((XMLReader)parser, new InputSource(new StringReader(html)));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setParameter("encoding", outputEncoding);
            transformer.setOutputProperty("indent", formatOutput ? "yes" : "no");
            transformer.setOutputProperty("omit-xml-declaration", omitXml ? "yes" : "no");
            transformer.setOutputProperty("encoding", outputEncoding);
            transformer.setOutputProperty("method", useXhtml ? "xml" : "html");
            OutputFormat format = this.getOutputFormat(outputEncoding);
            HTMLSerializer serializer = this.getHTMLSerializer(out, format);
            transformer.transform(source, new SAXResult((ContentHandler)serializer));
            Date end = new Date();
            String cleanHtml = this.trim(html, out.getBuffer().toString());
            this.errorMessages = sanitizingFilter.getErrorMessages();
            return new CleanResults(start, end, cleanHtml, null, this.errorMessages);
        }
        catch (Exception e) {
            throw new ScanException(e);
        }
    }
}

