/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.auth.SecurityTokenCodec;
import org.apache.shindig.auth.SecurityTokenException;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.RenderingContext;
import org.apache.shindig.gadgets.process.ProcessingException;
import org.apache.shindig.gadgets.process.Processor;
import org.apache.shindig.gadgets.servlet.GadgetsHandlerApi;
import org.apache.shindig.gadgets.spec.Feature;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.LinkSpec;
import org.apache.shindig.gadgets.spec.ModulePrefs;
import org.apache.shindig.gadgets.spec.UserPref;
import org.apache.shindig.gadgets.spec.View;
import org.apache.shindig.gadgets.uri.IframeUriManager;
import org.apache.shindig.protocol.conversion.BeanDelegator;
import org.apache.shindig.protocol.conversion.BeanFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GadgetsHandlerService {
    @VisibleForTesting
    static final Map<Class<?>, Class<?>> apiClasses = new ImmutableMap.Builder().put(View.class, GadgetsHandlerApi.View.class).put(UserPref.class, GadgetsHandlerApi.UserPref.class).put(UserPref.EnumValuePair.class, GadgetsHandlerApi.EnumValuePair.class).put(ModulePrefs.class, GadgetsHandlerApi.ModulePrefs.class).put(Feature.class, GadgetsHandlerApi.Feature.class).put(LinkSpec.class, GadgetsHandlerApi.LinkSpec.class).put(View.ContentType.class, GadgetsHandlerApi.ViewContentType.class).put(UserPref.DataType.class, GadgetsHandlerApi.UserPrefDataType.class).build();
    @VisibleForTesting
    static final Map<Enum<?>, Enum<?>> enumConversionMap = new ImmutableMap.Builder().putAll(BeanDelegator.createDefaultEnumMap(View.ContentType.class, GadgetsHandlerApi.ViewContentType.class)).putAll(BeanDelegator.createDefaultEnumMap(UserPref.DataType.class, GadgetsHandlerApi.UserPrefDataType.class)).build();
    protected final Processor processor;
    protected final IframeUriManager iframeUriManager;
    protected final SecurityTokenCodec securityTokenCodec;
    protected final BeanDelegator beanDelegator;
    protected final BeanFilter beanFilter;

    @Inject
    public GadgetsHandlerService(Processor processor, IframeUriManager iframeUriManager, SecurityTokenCodec securityTokenCodec, BeanFilter beanFilter) {
        this.processor = processor;
        this.iframeUriManager = iframeUriManager;
        this.securityTokenCodec = securityTokenCodec;
        this.beanFilter = beanFilter;
        this.beanDelegator = new BeanDelegator(apiClasses, enumConversionMap);
    }

    public GadgetsHandlerApi.MetadataResponse getMetadata(GadgetsHandlerApi.MetadataRequest request) throws ProcessingException {
        if (request.getUrl() == null) {
            throw new ProcessingException("Missing url paramater", 400);
        }
        if (request.getContainer() == null) {
            throw new ProcessingException("Missing container paramater", 400);
        }
        if (request.getFields() == null) {
            throw new ProcessingException("Missing fields paramater", 400);
        }
        Set fields = this.beanFilter.processBeanFields(request.getFields());
        MetadataGadgetContext context = new MetadataGadgetContext(request);
        Gadget gadget = this.processor.process(context);
        String iframeUrl = fields.contains("iframeurl") || fields.contains("*") ? this.iframeUriManager.makeRenderingUri(gadget).toString() : null;
        Boolean needsTokenRefresh = fields.contains("needstokenrefresh") || fields.contains("*") ? Boolean.valueOf(gadget.getAllFeatures().contains("auth-refresh")) : null;
        return this.createMetadataResponse(((GadgetContext)context).getUrl(), gadget.getSpec(), iframeUrl, needsTokenRefresh, fields);
    }

    public GadgetsHandlerApi.TokenResponse getToken(GadgetsHandlerApi.TokenRequest request) throws SecurityTokenException, ProcessingException {
        if (request.getUrl() == null) {
            throw new ProcessingException("Missing url paramater", 400);
        }
        if (request.getContainer() == null) {
            throw new ProcessingException("Missing container paramater", 400);
        }
        if (request.getFields() == null) {
            throw new ProcessingException("Missing fields paramater", 400);
        }
        Set fields = this.beanFilter.processBeanFields(request.getFields());
        SecurityToken tokenData = this.convertToken(request.getToken(), request.getContainer(), request.getUrl().toString());
        String token = this.securityTokenCodec.encodeToken(tokenData);
        return this.createTokenResponse(request.getUrl(), token, fields);
    }

    private SecurityToken convertToken(GadgetsHandlerApi.TokenData token, String container, String url) {
        if (token == null) {
            return null;
        }
        return (SecurityToken)this.beanDelegator.createDelegator((Object)token, SecurityToken.class, (Map)ImmutableMap.of((Object)"container", (Object)container, (Object)"appid", (Object)url, (Object)"appurl", (Object)url));
    }

    public GadgetsHandlerApi.BaseResponse createBaseResponse(Uri url, String error) {
        return (GadgetsHandlerApi.BaseResponse)this.beanDelegator.createDelegator((Object)error, GadgetsHandlerApi.BaseResponse.class, (Map)ImmutableMap.of((Object)"url", (Object)url, (Object)"error", (Object)error));
    }

    private GadgetsHandlerApi.MetadataResponse createMetadataResponse(Uri url, GadgetSpec spec, String iframeUrl, Boolean needsTokenRefresh, Set<String> fields) {
        return (GadgetsHandlerApi.MetadataResponse)this.beanFilter.createFilteredBean(this.beanDelegator.createDelegator((Object)spec, GadgetsHandlerApi.MetadataResponse.class, (Map)ImmutableMap.of((Object)"url", (Object)url, (Object)"error", (Object)"<NULL sentinel>", (Object)"iframeurl", (Object)BeanDelegator.nullable((Object)iframeUrl), (Object)"needstokenrefresh", (Object)BeanDelegator.nullable((Object)needsTokenRefresh))), fields);
    }

    private GadgetsHandlerApi.TokenResponse createTokenResponse(Uri url, String token, Set<String> fields) {
        return (GadgetsHandlerApi.TokenResponse)this.beanFilter.createFilteredBean(this.beanDelegator.createDelegator((Object)"empty", GadgetsHandlerApi.TokenResponse.class, (Map)ImmutableMap.of((Object)"url", (Object)url, (Object)"error", (Object)"<NULL sentinel>", (Object)"token", (Object)BeanDelegator.nullable((Object)token))), fields);
    }

    protected class MetadataGadgetContext
    extends GadgetContext {
        private final GadgetsHandlerApi.MetadataRequest request;
        private final SecurityToken token;

        public MetadataGadgetContext(GadgetsHandlerApi.MetadataRequest request) {
            this.request = request;
            this.token = GadgetsHandlerService.this.convertToken(request.getToken(), request.getContainer(), request.getUrl().toString());
        }

        public Uri getUrl() {
            return this.request.getUrl();
        }

        public String getContainer() {
            return this.request.getContainer();
        }

        public RenderingContext getRenderingContext() {
            return RenderingContext.METADATA;
        }

        public int getModuleId() {
            return 1;
        }

        public Locale getLocale() {
            return this.request.getLocale();
        }

        public boolean getIgnoreCache() {
            return this.request.getIgnoreCache();
        }

        public boolean getDebug() {
            return this.request.getDebug();
        }

        public String getView() {
            return this.request.getView();
        }

        public SecurityToken getToken() {
            return this.token;
        }
    }
}

