/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.servlet.HttpUtil;
import org.apache.shindig.common.servlet.InjectedServlet;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.gadgets.oauth.OAuthCallbackState;

public class OAuthCallbackServlet
extends InjectedServlet {
    private static final long serialVersionUID = 7126255229334669172L;
    public static final String CALLBACK_STATE_PARAM = "cs";
    public static final String REAL_DOMAIN_PARAM = "d";
    private static final int ONE_HOUR_IN_SECONDS = 3600;
    private static final String RESP_BODY = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html>\n<head>\n<title>Close this window</title>\n</head>\n<body>\n<script type='text/javascript'>\ntry {\n  window.opener.gadgets.io.oauthReceivedCallbackUrl_ = document.location.href;\n} catch (e) {\n}\nwindow.close();\n</script>\nClose this window.\n</body>\n</html>\n";
    private transient BlobCrypter stateCrypter;

    @Inject
    public void setStateCrypter(@Named(value="shindig.oauth.state-crypter") BlobCrypter stateCrypter) {
        this.checkInitialized();
        this.stateCrypter = stateCrypter;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        OAuthCallbackState callbackState = new OAuthCallbackState(this.stateCrypter, req.getParameter(CALLBACK_STATE_PARAM));
        if (callbackState.getRealCallbackUrl() != null) {
            UriBuilder realUri = UriBuilder.parse((String)callbackState.getRealCallbackUrl());
            Map params = UriBuilder.splitParameters((String)req.getQueryString());
            for (Map.Entry entry : params.entrySet()) {
                realUri.putQueryParameter((String)entry.getKey(), (Iterable)entry.getValue());
            }
            realUri.removeQueryParameter(CALLBACK_STATE_PARAM);
            HttpUtil.setCachingHeaders((HttpServletResponse)resp, (int)3600, (boolean)true);
            resp.sendRedirect(realUri.toString());
            return;
        }
        HttpUtil.setCachingHeaders((HttpServletResponse)resp, (int)3600, (boolean)true);
        resp.setContentType("text/html; charset=UTF-8");
        resp.getWriter().write(RESP_BODY);
    }
}

