/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.index;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.xcmis.search.lucene.index.IndexTransaction;
import org.xcmis.search.lucene.index.IndexTransactionModificationReport;
import org.xcmis.spi.utils.Logger;

public class LuceneIndexTransaction
implements IndexTransaction<Document> {
    private final Map<String, Document> addedDocuments;
    private final Set<String> deletedDocuments;
    private final Logger log = Logger.getLogger(LuceneIndexTransaction.class);

    public LuceneIndexTransaction(Map<String, Document> addedDocuments, Set<String> deletedDocuments) {
        this.addedDocuments = addedDocuments;
        this.deletedDocuments = deletedDocuments;
    }

    @Override
    public IndexTransaction<Document> apply(IndexTransactionModificationReport report) {
        HashMap<String, Document> newAddedDocuments = new HashMap<String, Document>();
        HashSet<String> newRemovedDocuments = new HashSet<String>();
        newAddedDocuments.putAll(this.getAddedDocuments());
        newRemovedDocuments.addAll(this.getRemovedDocuments());
        for (String addedUuid : report.getAddedDocuments()) {
            newAddedDocuments.remove(addedUuid);
        }
        for (String removedUuid : report.getRemovedDocuments()) {
            newRemovedDocuments.remove(removedUuid);
        }
        return new LuceneIndexTransaction(newAddedDocuments, newRemovedDocuments);
    }

    @Override
    public Map<String, Document> getAddedDocuments() {
        return this.addedDocuments;
    }

    @Override
    public long getAddedDocumentSizeInBytes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getRemovedDocuments() {
        return this.deletedDocuments;
    }

    @Override
    public boolean hasAddedDocuments() {
        return this.addedDocuments.size() > 0;
    }

    @Override
    public boolean hasModifacationsDocuments() {
        return this.deletedDocuments.size() > 0;
    }
}

