/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcache;

import javax.portlet.RenderResponse;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.portletcache.BufferedRenderResponse;
import org.exoplatform.services.portletcache.MarkupFragment;
import org.exoplatform.services.portletcache.PortletRenderContext;
import org.exoplatform.services.portletcache.WindowKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PortletRenderer
implements Loader<WindowKey, MarkupFragment, PortletRenderContext> {
    private final Log log;

    PortletRenderer(Log log) {
        this.log = log;
    }

    public MarkupFragment retrieve(PortletRenderContext context, WindowKey key) throws Exception {
        long expirationCacheMillis;
        BufferedRenderResponse bufferedResp;
        block6: {
            bufferedResp = new BufferedRenderResponse(context.resp);
            context.chain.doFilter(context.req, (RenderResponse)bufferedResp);
            long now = System.currentTimeMillis();
            String expirationCache = bufferedResp.getExpirationCache();
            expirationCacheMillis = now;
            if (expirationCache != null) {
                try {
                    int expirationCacheSec = Integer.parseInt(expirationCache);
                    if (expirationCacheSec == -1) {
                        expirationCacheMillis = Long.MAX_VALUE;
                    } else if (expirationCacheSec > 0) {
                        expirationCacheMillis += (long)(1000 * expirationCacheSec);
                    }
                }
                catch (NumberFormatException e) {
                    if (!this.log.isWarnEnabled()) break block6;
                    this.log.warn((Object)("Incorrect expiration cache value " + expirationCache));
                }
            }
        }
        return new MarkupFragment(expirationCacheMillis, bufferedResp.getBytes());
    }
}

