/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jbpm.JbpmException;
import org.jbpm.command.AbstractProcessInstanceBaseCommand;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.node.TaskNode;
import org.jbpm.job.Job;
import org.jbpm.job.Timer;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class ChangeProcessInstanceVersionCommand
extends AbstractProcessInstanceBaseCommand {
    private static final long serialVersionUID = 2277080393930008224L;
    private int newVersion = -1;
    private static final Log log = LogFactory.getLog((Class)ChangeProcessInstanceVersionCommand.class);
    private Map nodeNameMapping = new HashMap();
    private Map taskNameMapping = new HashMap();

    public ChangeProcessInstanceVersionCommand() {
    }

    public ChangeProcessInstanceVersionCommand(long processId, int newVersion) {
        super.setProcessInstanceId(processId);
        this.newVersion = newVersion;
    }

    public String getAdditionalToStringInformation() {
        return ";newVersion=" + this.newVersion;
    }

    private ProcessDefinition loadNewProcessDefinition(String processName) {
        if (this.newVersion <= 0) {
            return this.getJbpmContext().getGraphSession().findLatestProcessDefinition(processName);
        }
        return this.getJbpmContext().getGraphSession().findProcessDefinition(processName, this.newVersion);
    }

    public ProcessInstance execute(ProcessInstance pi) {
        ProcessDefinition oldDef = pi.getProcessDefinition();
        ProcessDefinition newDef = this.loadNewProcessDefinition(oldDef.getName());
        if (newDef == null) {
            throw new JbpmException("Process definition " + oldDef.getName() + " in version " + this.newVersion + " not found.");
        }
        log.debug((Object)("Start changing process id " + pi.getId() + " from version " + pi.getProcessDefinition().getVersion() + " to new version " + newDef.getVersion()));
        pi.setProcessDefinition(newDef);
        this.changeTokenVersion(pi.getRootToken());
        log.debug((Object)("process id " + pi.getId() + " changed to version " + pi.getProcessDefinition().getVersion()));
        return pi;
    }

    private ProcessDefinition getNewProcessDefinition(Token t) {
        return t.getProcessInstance().getProcessDefinition();
    }

    private void changeTokenVersion(Token token) {
        ProcessDefinition newDef = this.getNewProcessDefinition(token);
        log.debug((Object)("change token id " + token.getId() + " to new version " + newDef.getVersion()));
        Node oldNode = token.getNode();
        Node newNode = this.findReplacementNode(newDef, oldNode);
        token.setNode(newNode);
        this.adjustTimersForToken(token);
        this.adjustTaskInstancesForToken(token);
        Map children = token.getChildren();
        if (children != null) {
            Iterator i = children.values().iterator();
            while (i.hasNext()) {
                this.changeTokenVersion((Token)i.next());
            }
        }
    }

    private void adjustTaskInstancesForToken(Token token) {
        ProcessDefinition newDef = this.getNewProcessDefinition(token);
        Iterator i = this.getTasksForToken(token).iterator();
        while (i.hasNext()) {
            TaskInstance ti = (TaskInstance)i.next();
            Task oldTask = ti.getTask();
            TaskNode oldNode = oldTask.getTaskNode();
            Task newTask = this.findReplacementTask(newDef, oldNode, oldTask);
            ti.setTask(newTask);
            log.debug((Object)("change dependent task-instance with id " + oldTask.getId()));
        }
    }

    private void adjustTimersForToken(Token token) {
        ProcessDefinition newDef = this.getNewProcessDefinition(token);
        List jobs = this.getJbpmContext().getJobSession().findJobsByToken(token);
        Iterator i = jobs.iterator();
        while (i.hasNext()) {
            Timer timer;
            Job job = (Job)i.next();
            if (!(job instanceof Timer) || (timer = (Timer)job).getGraphElement() == null) continue;
            if (timer.getGraphElement() instanceof Task) {
                Task oldTask = (Task)timer.getGraphElement();
                TaskNode oldNode = oldTask.getTaskNode();
                timer.setGraphElement(this.findReplacementTask(newDef, oldNode, oldTask));
                continue;
            }
            GraphElement oldNode = timer.getGraphElement();
            timer.setGraphElement(this.findReplacementNode(newDef, oldNode));
        }
    }

    private Node findReplacementNode(ProcessDefinition newDef, GraphElement oldNode) {
        String name = this.getReplacementNodeName(oldNode);
        Node newNode = newDef.findNode(name);
        if (newNode == null) {
            throw new JbpmException("node with name '" + name + "' not found in new process definition");
        }
        return newNode;
    }

    private Task findReplacementTask(ProcessDefinition newDef, Node oldNode, Task oldTask) {
        String replacementTaskName = this.getReplacementTaskName(oldTask);
        Node newTaskNode = this.findReplacementNode(newDef, oldNode);
        Session session = this.getJbpmContext().getSession();
        Long newTaskId = (Long)session.getNamedQuery("TaskMgmtSession.findTaskForNode").setString("taskName", replacementTaskName).setLong("taskNodeId", newTaskNode.getId()).uniqueResult();
        if (newTaskId == null) {
            throw new JbpmException("Task '" + replacementTaskName + "' for node '" + newTaskNode.getName() + "' not found in new process definition");
        }
        return (Task)session.load(Task.class, (Serializable)newTaskId);
    }

    private String getReplacementNodeName(GraphElement oldNode) {
        String oldName;
        String string = oldName = oldNode instanceof Node ? ((Node)oldNode).getFullyQualifiedName() : oldNode.getName();
        if (this.nodeNameMapping.containsKey(oldName)) {
            return (String)this.nodeNameMapping.get(oldName);
        }
        return oldName;
    }

    private String getReplacementTaskName(Task oldTask) {
        String oldName = oldTask.getName();
        if (this.taskNameMapping.containsKey(oldName)) {
            return (String)this.taskNameMapping.get(oldName);
        }
        return oldName;
    }

    private List getTasksForToken(Token token) {
        Query query = this.getJbpmContext().getSession().getNamedQuery("TaskMgmtSession.findTaskInstancesByTokenId");
        query.setLong("tokenId", token.getId());
        return query.list();
    }

    public Map getNodeNameMapping() {
        return this.nodeNameMapping;
    }

    public void setNodeNameMapping(Map nameMapping) {
        this.nodeNameMapping = nameMapping == null ? new HashMap() : nameMapping;
    }

    public int getNewVersion() {
        return this.newVersion;
    }

    public void setNewVersion(int newVersion) {
        this.newVersion = newVersion;
    }

    public Map getTaskNameMapping() {
        return this.taskNameMapping;
    }

    public void setTaskNameMapping(Map nameMapping) {
        this.taskNameMapping = nameMapping == null ? new HashMap() : nameMapping;
    }

    public long getProcessId() {
        if (this.getProcessInstanceIds() != null && this.getProcessInstanceIds().length > 0) {
            return this.getProcessInstanceIds()[0];
        }
        return 0L;
    }

    public void setProcessId(long processId) {
        super.setProcessInstanceId(processId);
    }

    public Map getNameMapping() {
        return this.getNodeNameMapping();
    }

    public void setNameMapping(Map nameMapping) {
        this.setNodeNameMapping(nameMapping);
    }

    public ChangeProcessInstanceVersionCommand nodeNameMapping(Map nameMapping) {
        this.setNodeNameMapping(nameMapping);
        return this;
    }

    public ChangeProcessInstanceVersionCommand newVersion(int newVersion) {
        this.setNewVersion(newVersion);
        return this;
    }

    public ChangeProcessInstanceVersionCommand taskNameMapping(Map nameMapping) {
        this.setTaskNameMapping(nameMapping);
        return this;
    }

    public ChangeProcessInstanceVersionCommand nodeNameMappingAdd(String oldNodeName, String newNodeName) {
        if (this.nodeNameMapping == null) {
            this.nodeNameMapping = new HashMap();
        }
        this.nodeNameMapping.put(oldNodeName, newNodeName);
        return this;
    }

    public ChangeProcessInstanceVersionCommand taskNameMappingAdd(String oldTaskName, String newNodeName) {
        if (this.taskNameMapping == null) {
            this.taskNameMapping = new HashMap();
        }
        this.taskNameMapping.put(oldTaskName, newNodeName);
        return this;
    }
}

