/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.io.IOException;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import org.exoplatform.commons.utils.SecurityHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnifiedClassLoader
extends ClassLoader {
    private final ClassLoader[] cls;

    UnifiedClassLoader(ClassLoader ... cls) {
        super(Thread.currentThread().getContextClassLoader());
        if (cls == null || cls.length == 0) {
            throw new IllegalArgumentException("The array of ClassLoader cannot be empty");
        }
        this.cls = cls;
    }

    protected ClassLoader[] getClassLoaders() {
        return this.cls;
    }

    @Override
    public URL getResource(String name) {
        ClassLoader[] cls = this.getClassLoaders();
        for (int i = cls.length - 1; i >= 0; --i) {
            ClassLoader cl = cls[i];
            URL url = cl.getResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ClassLoader[] cls = this.getClassLoaders();
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        int length = cls.length;
        for (int i = 0; i < length; ++i) {
            Enumeration<URL> eUrls = cls[i].getResources(name);
            if (eUrls == null || !eUrls.hasMoreElements()) continue;
            urls.addAll(Collections.list(eUrls));
        }
        return Collections.enumeration(urls);
    }

    protected static UnifiedClassLoader createUnifiedClassLoaderInPrivilegedMode(final ClassLoader ... cls) {
        return (UnifiedClassLoader)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<UnifiedClassLoader>(){

            @Override
            public UnifiedClassLoader run() {
                return new UnifiedClassLoader(cls);
            }
        });
    }
}

