/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.web.AbstractFilter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PortalContainerFilter
extends AbstractFilter {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.PortalContainerFilter");

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (PortalContainer.isPortalContainerNameDisabled(this.servletContextName)) {
            this.onPortalContainerDisabled(request, response, chain);
            return;
        }
        chain.doFilter(request, response);
    }

    protected void onPortalContainerDisabled(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (PropertyManager.isDevelopping()) {
            LOG.info((Object)("The portal container corresponding to the webapp '" + this.servletContextName + "' is disabled, thus the request is cancelled: target URI was " + ((HttpServletRequest)request).getRequestURI()));
        }
        ((HttpServletResponse)response).sendError(404);
    }
}

