/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.management.spi;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.spi.ManagedMetaData;
import org.exoplatform.management.spi.ManagedMethodParameterMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedMethodMetaData
extends ManagedMetaData {
    private final Method method;
    private final Map<Integer, ManagedMethodParameterMetaData> parameters;
    private final ImpactType impact;

    public ManagedMethodMetaData(Method method, ImpactType impactType) throws IllegalArgumentException {
        if (method == null) {
            throw new IllegalArgumentException("The method cannot be null");
        }
        if (impactType == null) {
            throw new IllegalArgumentException("The impactType cannot be null");
        }
        this.method = method;
        this.impact = impactType;
        this.parameters = new HashMap<Integer, ManagedMethodParameterMetaData>();
    }

    public String getName() {
        return this.method.getName();
    }

    public ImpactType getImpact() {
        return this.impact;
    }

    public Method getMethod() {
        return this.method;
    }

    public void addParameter(ManagedMethodParameterMetaData parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("No null parameter accepted");
        }
        this.parameters.put(parameter.getIndex(), parameter);
    }

    public Collection<ManagedMethodParameterMetaData> getParameters() {
        return Collections.unmodifiableCollection(this.parameters.values());
    }
}

