/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.mop.core.api.workspace.content;

import java.util.Map;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.FormattedBy;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.NamingPrefix;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.ext.format.BaseEncodingObjectFormatter;
import org.gatein.mop.api.content.ContentType;
import org.gatein.mop.api.content.Customization;
import org.gatein.mop.core.api.workspace.WorkspaceCustomizationContextImpl;
import org.gatein.mop.core.api.workspace.content.WorkspaceClone;
import org.gatein.mop.core.api.workspace.content.WorkspaceCustomization;
import org.gatein.mop.core.api.workspace.content.WorkspaceSpecialization;

@PrimaryType(name="mop:customizationcontainer")
@NamingPrefix(value="mop")
@FormattedBy(value=BaseEncodingObjectFormatter.class)
public abstract class CustomizationContainer {
    @OneToOne
    @MappedBy(value="mop:customizations")
    public abstract WorkspaceCustomizationContextImpl getOwner();

    @OneToMany
    public abstract Map<String, WorkspaceCustomization> getCustomizations();

    @Create
    public abstract WorkspaceClone createClone();

    @Create
    public abstract WorkspaceSpecialization createSpecialization();

    public Customization<?> getCustomization(String name) {
        Map<String, WorkspaceCustomization> customizations = this.getCustomizations();
        return customizations.get(name);
    }

    public <S> Customization<S> customize(String name, ContentType<S> contentType, String contentId, S state) {
        Map<String, WorkspaceCustomization> contents = this.getCustomizations();
        WorkspaceClone content = this.createClone();
        contents.put(name, content);
        content.setContentId(contentId);
        content.setMimeType(contentType.getMimeType());
        content.setState(state);
        return content;
    }

    public <S> Customization<S> customize(String name, Customization<S> customization) {
        Map<String, WorkspaceCustomization> contents = this.getCustomizations();
        WorkspaceCustomization workspaceCustomization = (WorkspaceCustomization)customization;
        WorkspaceSpecialization content = this.createSpecialization();
        contents.put(name, content);
        content.setMimeType(workspaceCustomization.getMimeType());
        content.setContentId(workspaceCustomization.getContentId());
        content.setCustomization(workspaceCustomization);
        return content;
    }

    public String nameOf(Customization customization) {
        if (customization instanceof WorkspaceClone) {
            WorkspaceClone wc = (WorkspaceClone)customization;
            Map<String, WorkspaceCustomization> contents = this.getCustomizations();
            if (contents.containsValue(wc)) {
                return wc.getFooName();
            }
        }
        return null;
    }
}

