/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.jlr;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.reflext.spi.model.AnnotationModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaLangReflectAnnotationModel<E>
implements AnnotationModel<Type, E, Annotation, Method> {
    public Collection<Method> getAnnotationParameters(Annotation annotation) {
        Method[] methods = annotation.annotationType().getDeclaredMethods();
        ArrayList<Method> list = new ArrayList<Method>(methods.length);
        for (Method m : methods) {
            list.add(m);
        }
        return list;
    }

    public Type getAnnotationType(Annotation annotation) {
        return annotation.annotationType();
    }

    public String getAnnotationParameterName(Method parameter) {
        return parameter.getName();
    }

    public Type getAnnotationParameterType(Method parameter) {
        return parameter.getGenericReturnType();
    }

    public List<?> getAnnotationParameterValue(Annotation annotation, Method parameter) {
        try {
            Object value = parameter.invoke((Object)annotation, new Object[0]);
            if (value.getClass().isArray()) {
                Object[] array = (Object[])value;
                for (int i = 0; i < array.length; ++i) {
                    array[i] = this.unwrap(array[i]);
                }
                return Arrays.asList(array);
            }
            return Arrays.asList(this.unwrap(value));
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private Object unwrap(Object o) {
        if (o instanceof Enum) {
            return ((Enum)o).name();
        }
        return o;
    }
}

