/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import java.io.Serializable;
import javax.jcr.RepositoryException;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.CacheHandler;
import org.exoplatform.services.organization.Group;

public class JCRCacheHandler
extends CacheHandler {
    private static char DELIMITER = (char)58;
    private static final Log LOG = ExoLogger.getLogger((String)"exo-jcr-services.JCRCacheHandler");
    private final JCROrganizationServiceImpl jcrOrganizationServiceImpl;

    public JCRCacheHandler(CacheService cservice, JCROrganizationServiceImpl jcrOrganizationServiceImpl) {
        super(cservice);
        this.jcrOrganizationServiceImpl = jcrOrganizationServiceImpl;
    }

    public void removeGroupHierarchy(String groupId) {
        block3: {
            try {
                for (Group group : this.groupCache.getCachedObjects()) {
                    if (!group.getId().startsWith(groupId)) continue;
                    this.remove((Serializable)((Object)group.getId()), CacheHandler.CacheType.GROUP);
                    this.remove((Serializable)((Object)("g=" + group.getId())), CacheHandler.CacheType.MEMBERSHIP);
                }
            }
            catch (Exception e) {
                if (!LOG.isTraceEnabled()) break block3;
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
        }
    }

    protected Serializable createCacheKey(Serializable orgServiceKey) {
        if (orgServiceKey instanceof String) {
            try {
                return this.jcrOrganizationServiceImpl.getWorkingRepository().getConfiguration().getName() + DELIMITER + orgServiceKey;
            }
            catch (RepositoryException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
            catch (RepositoryConfigurationException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        return orgServiceKey;
    }

    protected boolean matchKey(Serializable cacheKey) {
        if (cacheKey instanceof String) {
            try {
                String prefix = this.jcrOrganizationServiceImpl.getWorkingRepository().getConfiguration().getName() + DELIMITER;
                return ((String)((Object)cacheKey)).startsWith(prefix);
            }
            catch (RepositoryException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
            catch (RepositoryConfigurationException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        return false;
    }

    protected Serializable createOrgServiceKey(Serializable cacheKey) {
        int indexOfDelimiter;
        if (cacheKey instanceof String && (indexOfDelimiter = ((String)((Object)cacheKey)).indexOf(DELIMITER)) >= 0) {
            return ((String)((Object)cacheKey)).substring(indexOfDelimiter + 1);
        }
        return cacheKey;
    }
}

