/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Serialized
public abstract class UIFormInputBase<T>
extends UIContainer
implements UIFormInput<T> {
    @Deprecated
    public static final boolean ENABLE = true;
    @Deprecated
    public static final boolean DISABLE = false;
    protected String name;
    private String label;
    protected String bindingField;
    protected List<Validator> validators;
    protected T defaultValue_;
    protected T value_;
    protected Class<T> typeValue_;
    @Deprecated
    protected boolean enable_ = true;
    protected boolean disabled = false;
    protected boolean readonly_ = false;
    private Map<String, String> attributes;

    public UIFormInputBase(String name, String bindingField, Class<T> typeValue) {
        this.name = name;
        this.bindingField = bindingField;
        this.typeValue_ = typeValue;
        this.setId(name);
    }

    protected UIFormInputBase() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getBindingField() {
        return this.bindingField;
    }

    public void setBindingField(String s) {
        this.bindingField = s;
    }

    public T getDefaultValue() {
        return this.defaultValue_;
    }

    public void setDefaultValue(T defaultValue) {
        this.defaultValue_ = defaultValue;
    }

    @Override
    public T getValue() {
        return this.value_;
    }

    @Override
    public UIFormInput<T> setValue(T value) {
        this.value_ = value;
        return this;
    }

    @Override
    public Class<T> getTypeValue() {
        return this.typeValue_;
    }

    @Override
    public void reset() {
        this.value_ = this.defaultValue_;
    }

    @Deprecated
    public boolean isEnable() {
        return !this.isDisabled();
    }

    @Deprecated
    public UIFormInputBase<T> setEnable(boolean enable) {
        return this.setDisabled(!enable);
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public UIFormInputBase<T> setDisabled(boolean disabled) {
        this.disabled = disabled;
        this.enable_ = !disabled;
        return this;
    }

    @Deprecated
    public boolean isEditable() {
        return !this.isReadOnly();
    }

    @Deprecated
    public UIFormInputBase<T> setEditable(boolean editable) {
        return this.setReadOnly(!editable);
    }

    public boolean isReadOnly() {
        return this.readonly_;
    }

    public UIFormInputBase<T> setReadOnly(boolean readonly) {
        this.readonly_ = readonly;
        return this;
    }

    public boolean isValid() {
        return this.isRendered() && !this.isDisabled();
    }

    @Override
    public <E extends Validator> UIFormInputBase<T> addValidator(Class<E> clazz, Object ... params) throws Exception {
        if (this.validators == null) {
            this.validators = new ArrayList<Validator>(3);
        }
        if (params.length > 0) {
            Class[] classes = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                classes[i] = params[i].getClass();
            }
            Constructor<E> constructor = clazz.getConstructor(classes);
            this.validators.add((Validator)constructor.newInstance(params));
            return this;
        }
        this.validators.add((Validator)clazz.newInstance());
        return this;
    }

    @Override
    public List<Validator> getValidators() {
        return this.validators;
    }

    public final void processDecode(WebuiRequestContext context) throws Exception {
        UIForm uiForm = (UIForm)this.getAncestorOfType(UIForm.class);
        String action = uiForm.getSubmitAction();
        Event event = this.createEvent(action, Event.Phase.DECODE, context);
        if (event != null) {
            event.broadcast();
        }
    }

    public boolean isMandatory() {
        if (this.validators == null) {
            return false;
        }
        for (Validator validator : this.validators) {
            if (!(validator instanceof MandatoryValidator)) continue;
            return true;
        }
        return false;
    }

    public abstract void decode(Object var1, WebuiRequestContext var2) throws Exception;

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getHTMLAttribute(String name) {
        if (this.attributes != null) {
            return this.attributes.get(name);
        }
        return null;
    }

    public void setHTMLAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(name, value);
    }

    protected void renderHTMLAttributes(Writer w) throws IOException {
        if (this.attributes != null) {
            w.append(" ");
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                String value = HTMLEntityEncoder.getInstance().encodeHTMLAttribute(entry.getValue());
                w.append(" ");
                w.append(entry.getKey() + "=\"" + value + "\"");
            }
            w.append(" ");
        }
    }

    protected void renderInputBaseComponent(Writer w, String tag, Map<String, String> attributes) throws IOException {
        this.renderInputBaseComponent(w, tag, this.getId(), attributes);
    }

    protected void renderInputBaseComponent(Writer w, String tag, String id, Map<String, String> attributes) throws IOException {
        w.write("<" + tag);
        w.write(" id=\"" + id + "\"");
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            w.append(" ");
            w.append(entry.getKey() + "=\"" + entry.getValue() + "\"");
        }
        this.renderHTMLAttributes(w);
        w.write("></" + tag + ">");
    }
}

