/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form.validator;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.AbstractValidator;

public class DateTimeValidator
extends AbstractValidator
implements Serializable {
    protected String getMessageLocalizationKey() {
        return "DateTimeValidator.msg.Invalid-input";
    }

    protected boolean isValid(String value, UIFormInput uiInput) {
        UIFormDateTimeInput uiDateInput = (UIFormDateTimeInput)uiInput;
        SimpleDateFormat sdf = new SimpleDateFormat(uiDateInput.getDatePattern_().trim());
        sdf.setLenient(false);
        try {
            sdf.parse(value);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    protected String trimmedValueOrNullIfBypassed(String value, UIFormInput uiInput, boolean exceptionOnMissingMandatory, boolean trimValue) throws Exception {
        if (!(uiInput instanceof UIFormDateTimeInput)) {
            return null;
        }
        return super.trimmedValueOrNullIfBypassed(value, uiInput, exceptionOnMissingMandatory, trimValue);
    }

    protected Object[] getMessageArgs(String value, UIFormInput uiInput) throws Exception {
        return new Object[]{this.getLabelFor(uiInput), value};
    }
}

