/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form.validator;

import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.AbstractValidator;

@Serialized
public class StringLengthValidator
extends AbstractValidator {
    private Integer min_ = 0;
    private Integer max_ = 0;

    public StringLengthValidator() {
    }

    public StringLengthValidator(Integer max) {
        this.max_ = max;
    }

    public StringLengthValidator(Integer min, Integer max) {
        this.min_ = min;
        this.max_ = max;
    }

    protected String getMessageLocalizationKey() {
        return "StringLengthValidator.msg.length-invalid";
    }

    protected boolean isValid(String value, UIFormInput uiInput) {
        int length = this.getValue(value).length();
        return this.min_ <= length && this.max_ >= length;
    }

    protected String getValue(String value) {
        return value.trim();
    }

    protected Object[] getMessageArgs(String value, UIFormInput uiInput) throws Exception {
        return new Object[]{this.getLabelFor(uiInput), this.min_.toString(), this.max_.toString()};
    }
}

