/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JRuntimeException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xslf.XSLFSlideShow;
import org.apache.poi.xslf.extractor.XSLFPowerPointExtractor;
import org.apache.xmlbeans.XmlException;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.document.DocumentReadException;
import org.exoplatform.services.document.impl.BaseDocumentReader;
import org.exoplatform.services.document.impl.POIPropertiesReader;

public class MSXPPTDocumentReader
extends BaseDocumentReader {
    public String[] getMimeTypes() {
        return new String[]{"application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.openxmlformats-officedocument.presentationml.slideshow", "application/vnd.ms-powerpoint.presentation.macroenabled.12", "application/vnd.ms-powerpoint.slideshow.macroenabled.12"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentAsText(final InputStream is) throws IOException, DocumentReadException {
        XSLFPowerPointExtractor ppe;
        if (is == null) {
            throw new NullPointerException("InputStream is null.");
        }
        if (is.available() == 0) {
            String string = "";
            return string;
        }
        try {
            ppe = (XSLFPowerPointExtractor)SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<XSLFPowerPointExtractor>(){

                @Override
                public XSLFPowerPointExtractor run() throws Exception {
                    return new XSLFPowerPointExtractor(OPCPackage.open((InputStream)is));
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof IOException) {
                throw new DocumentReadException("Can't open presentation.", cause);
            }
            if (cause instanceof OpenXML4JRuntimeException) {
                throw new DocumentReadException("Can't open presentation.", cause);
            }
            if (cause instanceof OpenXML4JException) {
                throw new DocumentReadException("Can't open presentation.", cause);
            }
            if (cause instanceof XmlException) {
                throw new DocumentReadException("Can't open presentation.", cause);
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
        String string = (String)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<String>(){

            @Override
            public String run() {
                return ppe.getText(true, true);
            }
        });
        return string;
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public String getContentAsText(InputStream is, String encoding) throws IOException, DocumentReadException {
        return this.getContentAsText(is);
    }

    public Properties getProperties(final InputStream is) throws IOException, DocumentReadException {
        final POIPropertiesReader reader = new POIPropertiesReader();
        try {
            SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    reader.readDCProperties((POIXMLDocument)new XSLFSlideShow(OPCPackage.open((InputStream)is)));
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof InvalidFormatException) {
                throw new DocumentReadException("Can't read properties from OOXML document", cause);
            }
            if (cause instanceof OpenXML4JException) {
                throw new DocumentReadException("Can't read properties from OOXML document", cause);
            }
            if (cause instanceof XmlException) {
                throw new DocumentReadException("Can't read properties from OOXML document", cause);
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
        return reader.getProperties();
    }
}

