/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.j2ee.websphere;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class WebsphereFilter
implements Filter {
    private Log log = ExoLogger.getLogger((String)"exo.core.component.security.core.WebsphereFilter");
    private static final String cookieName = "LtpaToken";
    private static final String cookieName2 = "LtpaToken2";

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (httpRequest.getQueryString() == null && httpRequest.getRequestURI() != null && httpRequest.getRequestURI().contains("/public")) {
            this.removeLtpaTokenCookie(httpRequest, httpResponse);
        } else if (httpRequest.getQueryString() != null && httpRequest.getQueryString().contains("UIPortalComponentLogin") && httpRequest.getRequestURI() != null && httpRequest.getRequestURI().contains("/public")) {
            this.removeLtpaTokenCookie(httpRequest, httpResponse);
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    private void removeLtpaTokenCookie(HttpServletRequest req, HttpServletResponse res) {
        Cookie[] cooks = req.getCookies();
        if (cooks != null) {
            for (Cookie cook : cooks) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("WebsphereFilter.removeLtpaTokenCookie() cook.getName() = " + cook.getName()));
                }
                if (cook == null || !cookieName.equalsIgnoreCase(cook.getName()) && !cookieName2.equalsIgnoreCase(cook.getName())) continue;
                cook.setMaxAge(0);
                cook.setPath("/");
                res.addCookie(cook);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)"WebsphereFilter.removeLtpaTokenCookie() REMOVED LtpaToken = ");
            }
        }
    }
}

