/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.ConstraintViolationException;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyManagerTrees;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyTreeContainer;
import org.exoplatform.ecm.webui.component.admin.taxonomy.action.UIActionTaxonomyManager;
import org.exoplatform.ecm.webui.component.admin.taxonomy.tree.info.UIPermissionTreeInfo;
import org.exoplatform.ecm.webui.form.UIDialogForm;
import org.exoplatform.ecm.webui.nodetype.selector.UINodeTypeSelector;
import org.exoplatform.ecm.webui.selector.ComponentSelector;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.tree.selectone.UIOneNodePathSelector;
import org.exoplatform.ecm.webui.utils.DialogFormUtil;
import org.exoplatform.ecm.webui.utils.LockUtil;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.taxonomy.TaxonomyTreeData;
import org.exoplatform.services.cms.taxonomy.impl.TaxonomyAlreadyExistsException;
import org.exoplatform.services.cms.taxonomy.impl.TaxonomyNodeAlreadyExistsException;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(type=UIFormMultiValueInputSet.class, id="WYSIWYGRichTextMultipleInputset", events={@EventConfig(listeners={UIDialogForm.AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIFormMultiValueInputSet.RemoveActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={PreviousViewPermissionActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={NextViewTreeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIDialogForm.OnchangeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ShowComponentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveReferenceActionListener.class}, confirm="DialogFormField.msg.confirm-delete", phase=Event.Phase.DECODE)})})
public class UIActionForm
extends UIDialogForm
implements UISelectable {
    private String parentPath_ = "";
    private String nodeTypeName_ = null;
    private boolean isAddNew_;
    private String scriptPath_ = null;
    private String rootPath_ = null;
    public static final String POPUP_COMPONENT = "PopupComponent";
    public static final String EXO_ACTIONS = "exo:actions";
    private static final Log LOG = ExoLogger.getLogger((String)"admin.UIActionForm");

    public UIActionForm() throws Exception {
        this.setActions(new String[]{"PreviousViewPermission", "Save", "NextViewTree"});
    }

    public void createNewAction(Node parentNode, String actionType, boolean isAddNew) throws Exception {
        this.reset();
        this.nodeTypeName_ = actionType;
        this.isAddNew_ = isAddNew;
        this.componentSelectors.clear();
        this.properties.clear();
        this.getChildren().clear();
        if (parentNode != null) {
            this.parentPath_ = parentNode.getPath();
        }
    }

    public void doSelect(String selectField, Object value) throws Exception {
        this.isUpdateSelect = true;
        UIComponent uicomponent = this.getChildById(selectField);
        if (UIFormStringInput.class.isInstance(uicomponent)) {
            ((UIFormStringInput)uicomponent).setValue((Object)value.toString());
        } else if (UIFormMultiValueInputSet.class.isInstance(uicomponent)) {
            ((UIFormMultiValueInputSet)uicomponent).setValue((List)((ArrayList)value));
        }
        UIActionTaxonomyManager uiManager = (UIActionTaxonomyManager)this.getAncestorOfType(UIActionTaxonomyManager.class);
        uiManager.removeChildById(POPUP_COMPONENT);
    }

    public String getCurrentPath() throws Exception {
        return this.parentPath_;
    }

    public void setCurrentPath(String path) {
        this.parentPath_ = path;
    }

    public String getWorkspace() {
        return this.getTaxoTreeData().getTaxoTreeWorkspace();
    }

    public String getRepositoryName() {
        return this.getTaxoTreeData().getRepository();
    }

    public TaxonomyTreeData getTaxoTreeData() {
        return ((UITaxonomyTreeContainer)this.getAncestorOfType(UITaxonomyTreeContainer.class)).getTaxonomyTreeData();
    }

    private String getTaxonomyTreeHomePath() throws Exception {
        TaxonomyTreeData taxoTreeData = this.getTaxoTreeData();
        String workspace = taxoTreeData.getTaxoTreeWorkspace();
        String homePath = taxoTreeData.getTaxoTreeHomePath();
        String systemWorkspace = ((UITaxonomyManagerTrees)this.getAncestorOfType(UITaxonomyManagerTrees.class)).getDmsSystemWorkspaceName();
        if (workspace.equals(systemWorkspace) && homePath.length() == 0) {
            homePath = this.getJcrPath("exoTaxoTreesStoragePath");
            taxoTreeData.setTaxoTreeHomePath(homePath);
        }
        return workspace + ":" + homePath;
    }

    private String getJcrPath(String path) {
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
        return nodeHierarchyCreator.getJcrPath(path);
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
        String workspace = dmsConfiguration.getConfig().getSystemWorkspace();
        return new JCRResourceResolver(workspace);
    }

    public String getTemplate() {
        return this.getDialogPath();
    }

    public String getDialogPath() {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String userName = Util.getPortalRequestContext().getRemoteUser();
        String dialogPath = null;
        if (this.nodeTypeName_ != null) {
            try {
                dialogPath = templateService.getTemplatePathByUser(true, this.nodeTypeName_, userName);
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
        }
        return dialogPath;
    }

    public void onchange(Event<?> event) throws Exception {
        this.setIsUpdateSelect(false);
    }

    public void renderField(String name) throws Exception {
        UIComponent uiInput = this.findComponentById(name);
        if ("homePath".equals(name)) {
            TaxonomyTreeData taxoTreeData = this.getTaxoTreeData();
            String homPath = this.getTaxonomyTreeHomePath();
            if (homPath.endsWith("/")) {
                homPath = homPath.substring(0, homPath.length() - 1);
            }
            ((UIFormStringInput)uiInput).setValue((Object)(homPath + "/" + taxoTreeData.getTaxoTreeName()));
        }
        super.renderField(name);
    }

    public String getTenmplateNodeType() {
        return this.nodeTypeName_;
    }

    public String getPath() {
        return this.scriptPath_;
    }

    public void setRootPath(String rootPath) {
        this.rootPath_ = rootPath;
    }

    public String getRootPath() {
        return this.rootPath_;
    }

    private void setPermissionAction(Node currentNode) throws Exception {
        Session session = this.getSession();
        Node exoActionNode = currentNode.getNode(EXO_ACTIONS);
        if (PermissionUtil.canChangePermission((Node)exoActionNode)) {
            if (exoActionNode.canAddMixin("exo:privilegeable")) {
                exoActionNode.addMixin("exo:privilegeable");
            }
            HashMap<String, String[]> perMap = new HashMap<String, String[]>();
            List<String> permsList = new ArrayList();
            ArrayList<String> idList = new ArrayList<String>();
            String identity = null;
            for (AccessControlEntry accessEntry : ((ExtendedNode)currentNode).getACL().getPermissionEntries()) {
                identity = accessEntry.getIdentity();
                if (idList.contains(identity)) continue;
                idList.add(identity);
                permsList = ((ExtendedNode)currentNode).getACL().getPermissions(identity);
                if (IdentityConstants.SYSTEM.equals(identity)) {
                    if (!permsList.contains("remove")) {
                        permsList.add("remove");
                    }
                } else {
                    permsList.remove("remove");
                }
                perMap.put(accessEntry.getIdentity(), permsList.toArray(new String[permsList.size()]));
            }
            ((ExtendedNode)exoActionNode).setPermissions(perMap);
            currentNode.save();
            session.save();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveActionListener
    extends EventListener<UIActionForm> {
        public void execute(Event<UIActionForm> event) throws Exception {
            UIActionForm uiForm = (UIActionForm)((Object)event.getSource());
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UIActionForm> {
        public void execute(Event<UIActionForm> event) throws Exception {
            UIActionForm uiForm = (UIActionForm)((Object)event.getSource());
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveReferenceActionListener
    extends EventListener<UIActionForm> {
        public void execute(Event<UIActionForm> event) throws Exception {
            UIActionForm uiForm = (UIActionForm)((Object)event.getSource());
            uiForm.isRemovePreference = true;
            String fieldName = event.getRequestContext().getRequestParameter("objectId");
            UIComponent uicomponent = uiForm.getChildById(fieldName);
            if (UIFormStringInput.class.isInstance(uicomponent)) {
                ((UIFormStringInput)uicomponent).setValue(null);
            } else if (UIFormMultiValueInputSet.class.isInstance(uicomponent)) {
                ((UIFormMultiValueInputSet)uicomponent).setValue(new ArrayList());
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShowComponentActionListener
    extends EventListener<UIActionForm> {
        public void execute(Event<UIActionForm> event) throws Exception {
            String[] stringArray;
            UIActionForm uiForm = (UIActionForm)((Object)event.getSource());
            UIActionTaxonomyManager uiManager = (UIActionTaxonomyManager)uiForm.getAncestorOfType(UIActionTaxonomyManager.class);
            uiForm.isShowingComponent = true;
            String fieldName = event.getRequestContext().getRequestParameter("objectId");
            Map fieldPropertiesMap = (Map)uiForm.componentSelectors.get(fieldName);
            String classPath = (String)fieldPropertiesMap.get("selectorClass");
            String rootPath = (String)fieldPropertiesMap.get("rootPath");
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = Class.forName(classPath, true, cl);
            UIComponent uiComp = uiManager.createUIComponent(clazz, null, null);
            String repositoryName = ((RepositoryService)uiForm.getApplicationComponent(RepositoryService.class)).getCurrentRepository().getConfiguration().getName();
            String selectorParams = (String)fieldPropertiesMap.get("selectorParams");
            if (uiComp instanceof UIOneNodePathSelector) {
                String[] arrParams;
                SessionProvider provider = WCMCoreUtils.getUserSessionProvider();
                String wsFieldName = (String)fieldPropertiesMap.get("workspaceField");
                String wsName = "";
                if (wsFieldName != null && wsFieldName.length() > 0) {
                    wsName = (String)((UIFormInputBase)uiForm.getUIInput(wsFieldName)).getValue();
                    ((UIOneNodePathSelector)uiComp).setIsDisable(wsName, true);
                }
                String[] filterType = new String[]{"nt:folder", "nt:unstructured"};
                ((UIOneNodePathSelector)uiComp).setAcceptedNodeTypesInPathPanel(filterType);
                ((UIOneNodePathSelector)uiComp).setAcceptedNodeTypesInTree(filterType);
                if (selectorParams != null && (arrParams = selectorParams.split(",")).length == 4) {
                    wsName = arrParams[1];
                    rootPath = arrParams[2];
                    ((UIOneNodePathSelector)uiComp).setIsDisable(wsName, true);
                    if (arrParams[3].indexOf(";") > -1) {
                        ((UIOneNodePathSelector)uiComp).setAcceptedMimeTypes(arrParams[3].split(";"));
                    } else {
                        ((UIOneNodePathSelector)uiComp).setAcceptedMimeTypes(new String[]{arrParams[3]});
                    }
                }
                if (rootPath == null) {
                    rootPath = "/";
                }
                ((UIOneNodePathSelector)uiComp).setRootNodeLocation(repositoryName, wsName, rootPath);
                ((UIOneNodePathSelector)uiComp).setShowRootPathSelect(true);
                ((UIOneNodePathSelector)uiComp).init(provider);
            } else if (uiComp instanceof UINodeTypeSelector) {
                ((UINodeTypeSelector)uiComp).setRepositoryName(repositoryName);
                UIFormMultiValueInputSet uiFormMultiValueInputSet = (UIFormMultiValueInputSet)uiForm.getChildById(fieldName);
                List values = uiFormMultiValueInputSet.getValue();
                ((UINodeTypeSelector)uiComp).init(1, values);
            }
            uiManager.initPopupComponent(uiComp, UIActionForm.POPUP_COMPONENT);
            String param = "returnField=" + fieldName;
            if (selectorParams == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = param;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = param;
                stringArray = stringArray3;
                stringArray3[1] = "selectorParams=" + selectorParams;
            }
            String[] params = stringArray;
            ((ComponentSelector)uiComp).setSourceComponent((UIComponent)uiForm, params);
            if (uiForm.isAddNew_) {
                UIContainer uiParent = (UIContainer)uiManager.getParent();
                uiParent.setRenderedChild(uiManager.getId());
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NextViewTreeActionListener
    extends EventListener<UIActionForm> {
        public void execute(Event<UIActionForm> event) throws Exception {
            UITaxonomyTreeContainer uiTaxonomyTreeContainer = (UITaxonomyTreeContainer)((UIActionForm)((Object)event.getSource())).getAncestorOfType(UITaxonomyTreeContainer.class);
            UITaxonomyManagerTrees uiTaxonomyManagerTrees = (UITaxonomyManagerTrees)uiTaxonomyTreeContainer.getAncestorOfType(UITaxonomyManagerTrees.class);
            TaxonomyTreeData taxoTreeData = uiTaxonomyTreeContainer.getTaxonomyTreeData();
            UIApplication uiApp = (UIApplication)uiTaxonomyTreeContainer.getAncestorOfType(UIApplication.class);
            if (!taxoTreeData.isEdit()) {
                String key = "UIActionForm.msg.not-created-tree";
                uiApp.addMessage(new ApplicationMessage(key, null, 1));
                return;
            }
            uiTaxonomyTreeContainer.viewStep(4);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaxonomyManagerTrees);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PreviousViewPermissionActionListener
    extends EventListener<UIActionForm> {
        public void execute(Event<UIActionForm> event) throws Exception {
            UITaxonomyTreeContainer uiTaxonomyTreeContainer = (UITaxonomyTreeContainer)((UIActionForm)((Object)event.getSource())).getAncestorOfType(UITaxonomyTreeContainer.class);
            UITaxonomyManagerTrees uiTaxonomyManagerTrees = (UITaxonomyManagerTrees)uiTaxonomyTreeContainer.getAncestorOfType(UITaxonomyManagerTrees.class);
            uiTaxonomyTreeContainer.viewStep(2);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaxonomyManagerTrees);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIActionForm> {
        public void execute(Event<UIActionForm> event) throws Exception {
            String lockToken;
            String targetPath;
            UIFormStringInput targetPathInput;
            UIActionForm uiActionForm = (UIActionForm)((Object)event.getSource());
            UITaxonomyTreeContainer uiTaxonomyTreeContainer = (UITaxonomyTreeContainer)uiActionForm.getAncestorOfType(UITaxonomyTreeContainer.class);
            UIPermissionTreeInfo uiPermissionInfo = (UIPermissionTreeInfo)uiTaxonomyTreeContainer.findFirstComponentOfType(UIPermissionTreeInfo.class);
            TaxonomyTreeData taxoTreeData = uiActionForm.getTaxoTreeData();
            UITaxonomyManagerTrees uiTaxonomyManagerTrees = (UITaxonomyManagerTrees)uiActionForm.getAncestorOfType(UITaxonomyManagerTrees.class);
            TaxonomyService taxonomyService = (TaxonomyService)uiTaxonomyTreeContainer.getApplicationComponent(TaxonomyService.class);
            String repository = ((RepositoryService)uiActionForm.getApplicationComponent(RepositoryService.class)).getCurrentRepository().getConfiguration().getName();
            String dmsSysWorkspace = ((UITaxonomyManagerTrees)uiTaxonomyTreeContainer.getAncestorOfType(UITaxonomyManagerTrees.class)).getDmsSystemWorkspaceName();
            UIApplication uiApp = (UIApplication)uiTaxonomyTreeContainer.getAncestorOfType(UIApplication.class);
            String name = taxoTreeData.getTaxoTreeName();
            String workspace = taxoTreeData.getTaxoTreeWorkspace();
            String homePath = taxoTreeData.getTaxoTreeHomePath();
            homePath = homePath != null ? homePath : "";
            boolean isEditTree = taxoTreeData.isEdit();
            if (homePath.length() == 0) {
                if (dmsSysWorkspace.equals(workspace)) {
                    homePath = uiActionForm.getJcrPath("exoTaxoTreesStoragePath");
                } else {
                    uiApp.addMessage(new ApplicationMessage("UITaxonomyTreeMainForm.msg.homepath-emty", null, 1));
                    return;
                }
            }
            if ((targetPathInput = uiActionForm.getUIStringInput("targetPath")) != null && ((targetPath = (String)targetPathInput.getValue()) == null || targetPath.length() == 0)) {
                uiApp.addMessage(new ApplicationMessage("UITaxonomyTreeMainForm.msg.targetPath-emty", null, 1));
                return;
            }
            boolean isChangeLocation = false;
            try {
                if (!isEditTree) {
                    uiTaxonomyTreeContainer.addTaxonomyTree(name, workspace, homePath, uiPermissionInfo.getPermBeans());
                } else {
                    isChangeLocation = uiTaxonomyTreeContainer.updateTaxonomyTree(name, workspace, homePath, taxoTreeData.getTaxoTreeActionName());
                }
            }
            catch (PathNotFoundException e) {
                uiApp.addMessage(new ApplicationMessage("UIActionForm.msg.path-invalid", null, 1));
                return;
            }
            catch (TaxonomyAlreadyExistsException e) {
                uiApp.addMessage(new ApplicationMessage("UIActionForm.msg.taxonomy-existed", null, 1));
                return;
            }
            catch (TaxonomyNodeAlreadyExistsException e) {
                uiApp.addMessage(new ApplicationMessage("UIActionForm.msg.taxonomy-node-existed", null, 1));
                return;
            }
            catch (ConstraintViolationException cViolationException) {
                Object[] args = new Object[]{name, homePath, workspace};
                uiApp.addMessage(new ApplicationMessage("UIActionForm.msg.constraint-violation-exception", args, 1));
                return;
            }
            Node currentNode = taxonomyService.getTaxonomyTree(name, true);
            Map sortedInputs = DialogFormUtil.prepareMap((List)uiActionForm.getChildren(), (Map)uiActionForm.getInputProperties(), (Map)uiActionForm.getInputOptions());
            ActionServiceContainer actionServiceContainer = (ActionServiceContainer)uiActionForm.getApplicationComponent(ActionServiceContainer.class);
            if (uiActionForm.nodeTypeName_.equals(taxoTreeData.getTaxoTreeActionTypeName()) && !isChangeLocation) {
                String[] arrFilterChar;
                String actionNameInput = (String)((JcrInputProperty)sortedInputs.get("/node/exo:name")).getValue();
                if (!Utils.isNameValid((String)actionNameInput, (String[])(arrFilterChar = new String[]{"&", "$", "@", ":", "]", "[", "*", "%", "!", "+", "(", ")", "'", "#", ";", "}", "{", "/", "|", "\""}))) {
                    uiApp.addMessage(new ApplicationMessage("UIActionForm.msg.name-not-allowed", null, 1));
                    return;
                }
                try {
                    CmsService cmsService = (CmsService)uiActionForm.getApplicationComponent(CmsService.class);
                    Node storedHomeNode = uiActionForm.getNode().getParent();
                    cmsService.storeNode(uiActionForm.nodeTypeName_, storedHomeNode, sortedInputs, false);
                    storedHomeNode.getSession().save();
                }
                catch (Exception e) {
                    uiApp.addMessage(new ApplicationMessage("UIActionForm.msg.canotChangeActionId", null, 1));
                    return;
                }
            }
            if (!isChangeLocation && actionServiceContainer.hasActions(currentNode)) {
                actionServiceContainer.removeAction(currentNode, taxoTreeData.getTaxoTreeActionName(), repository);
            }
            Session session = currentNode.getSession();
            if (uiActionForm.getCurrentPath().length() == 0) {
                uiActionForm.setCurrentPath(currentNode.getPath());
            }
            if (!PermissionUtil.canAddNode((Node)currentNode) || !PermissionUtil.canSetProperty((Node)currentNode)) {
                uiApp.addMessage(new ApplicationMessage("UIActionForm.msg.no-permission-add", null));
                return;
            }
            if (currentNode.isLocked() && (lockToken = LockUtil.getLockToken((Node)currentNode)) != null) {
                session.addLockToken(lockToken);
            }
            try {
                JcrInputProperty rootProp = (JcrInputProperty)sortedInputs.get("/node");
                String actionName = (String)((JcrInputProperty)sortedInputs.get("/node/exo:name")).getValue();
                String[] arrFilterChar = new String[]{"&", "$", "@", ":", "]", "[", "*", "%", "!", "+", "(", ")", "'", "#", ";", "}", "{", "/", "|", "\""};
                if (!Utils.isNameValid((String)actionName, (String[])arrFilterChar)) {
                    if (!isEditTree) {
                        Node taxonomyTreeNode = taxonomyService.getTaxonomyTree(name, true);
                        actionServiceContainer.removeAction(taxonomyTreeNode, repository);
                        taxonomyService.removeTaxonomyTree(name);
                    }
                    uiApp.addMessage(new ApplicationMessage("UIActionForm.msg.name-not-allowed", null, 1));
                    return;
                }
                if (rootProp == null) {
                    rootProp = new JcrInputProperty();
                    rootProp.setJcrPath("/node");
                    rootProp.setValue((Object)actionName);
                    sortedInputs.put("/node", rootProp);
                } else {
                    rootProp.setValue((Object)actionName);
                }
                if (currentNode.hasNode(UIActionForm.EXO_ACTIONS) && currentNode.getNode(UIActionForm.EXO_ACTIONS).hasNode(actionName)) {
                    Object[] args = new Object[]{actionName};
                    uiApp.addMessage(new ApplicationMessage("UIActionForm.msg.existed-action", args, 1));
                    return;
                }
                if (currentNode.isNew()) {
                    Object[] args = new String[]{currentNode.getPath()};
                    uiApp.addMessage(new ApplicationMessage("UIActionForm.msg.unable-add-action", args));
                    return;
                }
                boolean alreadyExistEXO_ACTION = currentNode.hasNode(UIActionForm.EXO_ACTIONS);
                actionServiceContainer.addAction(currentNode, uiActionForm.nodeTypeName_, sortedInputs);
                session.save();
                uiActionForm.setPermissionAction(currentNode);
                Node actionNode = actionServiceContainer.getAction(currentNode, actionName);
                taxoTreeData.setTaxoTreeActionName(actionNode.getName());
                uiActionForm.setIsOnchange(false);
                uiActionForm.setNodePath(actionNode.getPath());
                uiActionForm.createNewAction(currentNode, actionNode.getPrimaryNodeType().getName(), false);
                uiActionForm.reset();
                if (!alreadyExistEXO_ACTION) {
                    this.addPermission(currentNode.getNode(UIActionForm.EXO_ACTIONS), "exo:permissions", Util.getPortalRequestContext().getRemoteUser(), uiActionForm);
                }
                session.save();
            }
            catch (ConstraintViolationException cex) {
                uiApp.addMessage(new ApplicationMessage("UIActionForm.msg.constraint-violation-exception", null, 1));
                return;
            }
            catch (RepositoryException repo) {
                String key = "UIActionForm.msg.repository-exception";
                uiApp.addMessage(new ApplicationMessage(key, null, 1));
                return;
            }
            catch (NumberFormatException nume) {
                String key = "UIActionForm.msg.numberformat-exception";
                uiApp.addMessage(new ApplicationMessage(key, null, 1));
                return;
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
                uiApp.addMessage(new ApplicationMessage("UIActionForm.msg.unable-add", null));
                return;
            }
            taxoTreeData.setEdit(true);
            uiTaxonomyTreeContainer.refresh();
            uiTaxonomyTreeContainer.viewStep(4);
            uiTaxonomyManagerTrees.update();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaxonomyManagerTrees);
        }

        private void addPermission(Node node, String propertyName, String userId, UIActionForm uiForm) throws Exception {
            if (PermissionUtil.canChangePermission((Node)node)) {
                if (node.canAddMixin("exo:privilegeable")) {
                    node.addMixin("exo:privilegeable");
                }
                String removePermission = "remove";
                ArrayList<String> permissionList = ((ExtendedNode)node).getACL().getPermissions(userId);
                if (permissionList == null) {
                    permissionList = new ArrayList<String>();
                }
                permissionList.add(removePermission);
                ((ExtendedNode)node).setPermission(userId, permissionList.toArray(new String[0]));
                node.getSession().save();
            }
        }
    }
}

