/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.protocols.UNICAST;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class UNICAST_ConnectionTests
extends TestCase {
    private JChannel a;
    private JChannel b;
    private Address a_addr;
    private Address b_addr;
    private MyReceiver r1;
    private MyReceiver r2;
    private UNICAST u1;
    private UNICAST u2;
    private static final String props = "SHARED_LOOPBACK:UNICAST";
    private static final String CLUSTER = "UNICAST_ConnectionTests";

    protected void setUp() throws Exception {
        super.setUp();
        this.r1 = new MyReceiver("A");
        this.r2 = new MyReceiver("B");
        this.a = new JChannel(props);
        this.a.connect(CLUSTER);
        this.a_addr = this.a.getLocalAddress();
        this.a.setReceiver(this.r1);
        this.u1 = (UNICAST)this.a.getProtocolStack().findProtocol(UNICAST.class);
        this.b = new JChannel(props);
        this.b.connect(CLUSTER);
        this.b_addr = this.b.getLocalAddress();
        this.b.setReceiver(this.r2);
        this.u2 = (UNICAST)this.b.getProtocolStack().findProtocol(UNICAST.class);
        System.out.println("A=" + this.a_addr + ", B=" + this.b_addr);
    }

    protected void tearDown() throws Exception {
        Util.close(this.b, this.a);
        super.tearDown();
    }

    public void testRegularMessageReception() throws Exception {
        UNICAST_ConnectionTests.sendAndCheck(this.a, this.b_addr, 100, this.r2);
        UNICAST_ConnectionTests.sendAndCheck(this.b, this.a_addr, 50, this.r1);
    }

    public void testBothChannelsClosing() throws Exception {
        this.sendToEachOtherAndCheck(10);
        System.out.println("==== Closing the connections on both sides");
        this.u1.removeConnection(this.b_addr);
        this.u2.removeConnection(this.a_addr);
        this.r1.clear();
        this.r2.clear();
        this.sendToEachOtherAndCheck(10);
    }

    public void testAClosingUnilaterally() throws Exception {
        this.sendToEachOtherAndCheck(10);
        System.out.println("==== Closing the connection on A");
        this.u1.removeConnection(this.b_addr);
        UNICAST_ConnectionTests.sendAndCheck(this.a, this.b_addr, 10, this.r2);
    }

    public void testBClosingUnilaterally() throws Exception {
        this.sendToEachOtherAndCheck(10);
        System.out.println("==== Closing the connection on B");
        this.u2.removeConnection(this.a_addr);
        UNICAST_ConnectionTests.sendAndCheck(this.a, this.b_addr, 10, this.r2);
    }

    public void testAClosingUnilaterallyButLosingFirstMessage() throws Exception {
        this.sendToEachOtherAndCheck(10);
        System.out.println("==== Closing the connection on A");
        this.u1.removeConnection(this.b_addr);
        Drop drop = new Drop(true);
        this.a.getProtocolStack().insertProtocol((Protocol)drop, 2, UNICAST.class);
        UNICAST_ConnectionTests.sendAndCheck(this.a, this.b_addr, 10, this.r2);
    }

    private void sendToEachOtherAndCheck(int num) throws Exception {
        for (int i = 1; i <= num; ++i) {
            this.a.send(this.b_addr, null, (Serializable)((Object)("m" + i)));
            this.b.send(this.a_addr, null, (Serializable)((Object)("m" + i)));
        }
        List<Message> l1 = this.r1.getMessages();
        List<Message> l2 = this.r2.getMessages();
        for (int i = 0; i < 10 && (l1.size() != num || l2.size() != num); ++i) {
            Util.sleep(500L);
        }
        System.out.println("l1 = " + UNICAST_ConnectionTests.print(l1));
        System.out.println("l2 = " + UNICAST_ConnectionTests.print(l2));
        UNICAST_ConnectionTests.assertEquals((int)num, (int)l1.size());
        UNICAST_ConnectionTests.assertEquals((int)num, (int)l2.size());
    }

    private static void sendAndCheck(JChannel channel, Address dest, int num, MyReceiver receiver) throws Exception {
        receiver.clear();
        for (int i = 1; i <= num; ++i) {
            channel.send(dest, null, (Serializable)((Object)("m" + i)));
        }
        List<Message> list = receiver.getMessages();
        for (int i = 0; i < 10 && list.size() != num; ++i) {
            Util.sleep(500L);
        }
        System.out.println("list = " + UNICAST_ConnectionTests.print(list));
        int size = list.size();
        UNICAST_ConnectionTests.assertEquals((String)("list has " + size + " elements"), (int)num, (int)size);
    }

    private static String print(List<Message> list) {
        ArrayList<String> tmp = new ArrayList<String>(list.size());
        for (Message msg : list) {
            tmp.add((String)msg.getObject());
        }
        return Util.printListWithDelimiter(tmp, " ");
    }

    private static class Drop
    extends Protocol {
        private volatile boolean drop_next = false;

        private Drop(boolean drop_next) {
            this.drop_next = drop_next;
        }

        @Override
        public String getName() {
            return "Drop";
        }

        public void dropNext() {
            this.drop_next = true;
        }

        @Override
        public Object down(Event evt) {
            if (this.drop_next && evt.getType() == 1) {
                this.drop_next = false;
                return null;
            }
            return super.down(evt);
        }
    }

    private static class MyReceiver
    extends ReceiverAdapter {
        final String name;
        final List<Message> msgs = new ArrayList<Message>(20);

        public MyReceiver(String name) {
            this.name = name;
        }

        @Override
        public void receive(Message msg) {
            this.msgs.add(msg);
        }

        public List<Message> getMessages() {
            return this.msgs;
        }

        public void clear() {
            this.msgs.clear();
        }

        public int size() {
            return this.msgs.size();
        }

        public String toString() {
            return this.name;
        }
    }
}

