/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.deployment.plugins;

import java.util.Date;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.deployment.DeploymentPlugin;
import org.exoplatform.services.deployment.plugins.LinkDeploymentDescriptor;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class LinkDeploymentPlugin
extends DeploymentPlugin {
    private InitParams initParams;
    private RepositoryService repositoryService;
    private LinkManager linkManager;
    private Log log = ExoLogger.getLogger(this.getClass());
    public static final String UPDATE_EVENT = "WCMPublicationService.event.updateState";

    public LinkDeploymentPlugin(InitParams initParams, RepositoryService repositoryService, LinkManager linkManager, TaxonomyService taxonomyService) {
        this.initParams = initParams;
        this.repositoryService = repositoryService;
        this.linkManager = linkManager;
    }

    public void deploy(SessionProvider sessionProvider) throws Exception {
        Iterator iterator = this.initParams.getObjectParamIterator();
        LinkDeploymentDescriptor deploymentDescriptor = null;
        try {
            while (iterator.hasNext()) {
                ObjectParameter objectParameter = (ObjectParameter)iterator.next();
                deploymentDescriptor = (LinkDeploymentDescriptor)objectParameter.getObject();
                String sourcePath = deploymentDescriptor.getSourcePath();
                String targetPath = deploymentDescriptor.getTargetPath();
                String[] src = sourcePath.split(":");
                String[] tgt = targetPath.split(":");
                if (src.length == 3 && tgt.length == 3) {
                    ManageableRepository repository = this.repositoryService.getCurrentRepository();
                    Session session = sessionProvider.getSession(src[1], repository);
                    ManageableRepository repository2 = this.repositoryService.getCurrentRepository();
                    Session session2 = sessionProvider.getSession(tgt[1], repository2);
                    Node nodeSrc = session.getRootNode().getNode(src[2].substring(1));
                    Node nodeTgt = session2.getRootNode().getNode(tgt[2].substring(1));
                    this.linkManager.createLink(nodeTgt, "exo:taxonomyLink", nodeSrc);
                    ExoContainer container = ExoContainerContext.getCurrentContainer();
                    PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
                    String containerName = containerInfo.getContainerName();
                    ListenerService listenerService = WCMCoreUtils.getService(ListenerService.class, containerName);
                    CmsService cmsService = WCMCoreUtils.getService(CmsService.class, containerName);
                    listenerService.broadcast(UPDATE_EVENT, (Object)cmsService, (Object)nodeSrc);
                }
                if (!this.log.isInfoEnabled()) continue;
                this.log.info((Object)(sourcePath + " has a link into " + targetPath));
            }
        }
        catch (Exception ex) {
            this.log.error((Object)("create link from " + deploymentDescriptor.getSourcePath() + " to " + deploymentDescriptor.getTargetPath() + " is FAILURE at " + new Date().toString() + "\n"), (Throwable)ex);
            throw ex;
        }
    }
}

