/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.webcontent;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Value;
import org.exoplatform.services.html.HTMLDocument;
import org.exoplatform.services.html.HTMLNode;
import org.exoplatform.services.html.path.NodePath;
import org.exoplatform.services.html.path.NodePathParser;
import org.exoplatform.services.html.path.NodePathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TOCGeneratorService {
    private final int MaxHeadingNumbers = 6;
    private static final String TAG_NAME = "tagName=";
    private static final String HEADING_LEVEL = "headingLevel=";
    private static final String HEADING_NUMBER_TEXT = "headingNumberText=";

    public void updateTOC(Node htmlFile, List<Heading> headingList) throws Exception {
        String[] multiValues = new String[headingList.size()];
        ArrayList<String> stringValues = new ArrayList<String>();
        for (Heading heading : headingList) {
            StringBuffer strBuf = new StringBuffer();
            strBuf.append(TAG_NAME).append(this.toLowerCaseTextValue(heading.node)).append("|").append(HEADING_LEVEL).append(heading.headingLevel).append("|").append(HEADING_NUMBER_TEXT).append(heading.headingNumberText);
            stringValues.add(strBuf.toString());
        }
        htmlFile.setProperty("exo:htmlTOC", stringValues.toArray(multiValues));
    }

    public String getTOC(Node htmlNode) throws Exception {
        if (!htmlNode.hasProperty("exo:htmlTOC")) {
            return null;
        }
        Value[] values = htmlNode.getProperty("exo:htmlTOC").getValues();
        StringBuffer heading = new StringBuffer();
        for (Value value : values) {
            String[] contents = value.getString().split("\\|");
            String tagName = contents[0].substring(TAG_NAME.length());
            String headingLevel = contents[1].substring(HEADING_LEVEL.length());
            String headingNumberText = contents[2].substring(HEADING_NUMBER_TEXT.length());
            tagName = tagName.replaceAll("<\\/?([^>])+>", "").trim();
            tagName = "<h".concat(headingLevel).concat(">").concat(headingNumberText).concat(" ").concat(tagName).concat("</h").concat(headingLevel).concat(">");
            heading.append(tagName);
        }
        String result = heading.toString().replaceAll("\n", "");
        return result;
    }

    private boolean isHeadingTag(String nodeName) {
        return (nodeName.charAt(0) == 'h' || nodeName.charAt(0) == 'H') && nodeName.charAt(1) >= '1' && nodeName.charAt(1) <= '6';
    }

    private int getHeadingLevel(HTMLNode node) {
        String headingTagName = node.getName().name();
        return headingTagName.charAt(1) - 48;
    }

    public List<Heading> extractHeadings(HTMLDocument document) throws Exception {
        String bodyPath = "html.body";
        NodePath path = NodePathParser.toPath((String)bodyPath);
        HTMLNode node = NodePathUtil.lookFor((HTMLNode)document.getRoot(), (NodePath)path);
        int firstLevel = 0;
        if (node == null) {
            return null;
        }
        for (HTMLNode htmlNode : node.getChildrenNode()) {
            if (!this.isHeadingTag(htmlNode.getName().name())) continue;
            firstLevel = this.getHeadingLevel(htmlNode);
            break;
        }
        if (firstLevel == 0) {
            return null;
        }
        ArrayList<Heading> headingList = new ArrayList<Heading>();
        for (HTMLNode htmlNode : node.getChildrenNode()) {
            if (!this.isHeadingTag(htmlNode.getName().name()) || this.getHeadingLevel(htmlNode) < firstLevel) continue;
            headingList.add(new Heading(htmlNode));
        }
        int[] headingNumbers = new int[7];
        for (int i = 0; i < headingNumbers.length; ++i) {
            headingNumbers[i] = i < firstLevel ? -1 : 0;
        }
        for (Heading heading : headingList) {
            int headingLevel;
            int n = headingLevel = this.getHeadingLevel(heading.node);
            headingNumbers[n] = headingNumbers[n] + 1;
            for (int i = headingLevel + 1; i < headingNumbers.length; ++i) {
                headingNumbers[i] = 0;
            }
            heading.setHeadingLabel(headingNumbers, firstLevel);
        }
        return headingList;
    }

    private String toLowerCaseTextValue(HTMLNode node) {
        String text = node.getTextValue();
        int level = this.getHeadingLevel(node);
        text = text.replaceAll("\n", "");
        text = text.replace("</H" + level + ">", "</h" + level + ">");
        return text;
    }

    public class Heading {
        HTMLNode node;
        int headingLevel;
        String headingNumberText;

        Heading(HTMLNode node) {
            this.node = node;
            this.headingLevel = TOCGeneratorService.this.getHeadingLevel(node);
            this.headingNumberText = "";
        }

        private void setHeadingLabel(int[] headingNumbers, int firstLevel) {
            StringBuffer strBuffer = new StringBuffer();
            for (int i = 1; i < headingNumbers.length; ++i) {
                if (headingNumbers[i] < 0) continue;
                if (headingNumbers[i] == 0) break;
                if (i > firstLevel) {
                    strBuffer.append(".");
                }
                strBuffer.append(headingNumbers[i]);
            }
            this.headingNumberText = strBuffer.toString();
        }
    }
}

